/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.rhq.test.EqualsResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionEqualsChecker<T> {
    private Collection<T> expected;
    private Collection<T> actual;

    public void setExpected(Collection<T> expected) {
        this.expected = expected;
    }

    public void setActual(Collection<T> actual) {
        this.actual = actual;
    }

    public EqualsResult execute() {
        List<T> elementsThatShouldNotBePresent;
        List<T> elementsThatShouldBePresent;
        boolean isMatch = true;
        StringBuilder details = new StringBuilder();
        if (this.expected.size() != this.actual.size()) {
            isMatch = false;
            details.append("Expected " + this.expected.size() + " elements but found " + this.actual.size() + " elements\n");
        }
        if (!(elementsThatShouldBePresent = this.findMissingElements(this.expected, this.actual)).isEmpty()) {
            isMatch = false;
            details.append("Expected to find the following elements:\n\t" + this.toString(elementsThatShouldBePresent) + "\n\n");
        }
        if (!(elementsThatShouldNotBePresent = this.findMissingElements(this.actual, this.expected)).isEmpty()) {
            isMatch = false;
            details.append("Did not expect to find the following elements:\n\t" + this.toString(elementsThatShouldNotBePresent) + "\n\n");
        }
        return new EqualsResult(isMatch, details.toString());
    }

    private List<T> findMissingElements(Collection<T> elementsToSearchFor, Collection<T> elementsToSearch) {
        ArrayList<T> missingElements = new ArrayList<T>();
        for (T element : elementsToSearchFor) {
            if (elementsToSearch.contains(element)) continue;
            missingElements.add(element);
        }
        return missingElements;
    }

    private String toString(List<T> list) {
        StringBuilder buffer = new StringBuilder("[");
        for (T element : list) {
            buffer.append(element.toString() + ", ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        buffer.append("]");
        return buffer.toString();
    }
}

