/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.buddyreplication.BuddyLocator;
import org.jgroups.stack.IpAddress;

public class NextMemberBuddyLocator
implements BuddyLocator {
    private Log log = LogFactory.getLog((Class)NextMemberBuddyLocator.class);
    int numBuddies = 1;
    boolean ignoreColocatedBuddies = true;

    public void init(Properties props) {
        if (props != null) {
            String numBuddiesStr = props.getProperty("numBuddies");
            String ignoreColocatedBuddiesStr = props.getProperty("ignoreColocatedBuddies");
            if (numBuddiesStr != null) {
                this.numBuddies = Integer.parseInt(numBuddiesStr);
            }
            if (ignoreColocatedBuddiesStr != null) {
                this.ignoreColocatedBuddies = Boolean.valueOf(ignoreColocatedBuddiesStr);
            }
        }
    }

    public List locateBuddies(Map buddyPoolMap, List currentMembership, IpAddress dataOwner) {
        int numBuddiesToFind = Math.min(this.numBuddies, currentMembership.size());
        ArrayList<IpAddress> buddies = new ArrayList<IpAddress>(numBuddiesToFind);
        int dataOwnerSubscript = currentMembership.indexOf(dataOwner);
        int i = 0;
        boolean ignoreColocatedBuddiesForSession = this.ignoreColocatedBuddies;
        while (buddies.size() < numBuddiesToFind) {
            int subscript = i + dataOwnerSubscript + 1;
            if (subscript >= currentMembership.size()) {
                subscript -= currentMembership.size();
            }
            if (subscript >= currentMembership.size() && ignoreColocatedBuddiesForSession) {
                ignoreColocatedBuddiesForSession = false;
                i = 0;
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)("Expected to look for " + numBuddiesToFind + " buddies but could only find " + buddies.size() + " suitable candidates - trying with colocated buddies as well."));
                continue;
            }
            if (subscript >= currentMembership.size() && buddyPoolMap != null) {
                buddyPoolMap = null;
                ignoreColocatedBuddiesForSession = this.ignoreColocatedBuddies;
                i = 0;
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)("Expected to look for " + numBuddiesToFind + " buddies but could only find " + buddies.size() + " suitable candidates - trying again, ignoring buddy pool hints."));
                continue;
            }
            if (subscript >= currentMembership.size()) {
                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)("Expected to look for " + numBuddiesToFind + " buddies but could only find " + buddies.size() + " suitable candidates!"));
                break;
            }
            IpAddress candidate = (IpAddress)currentMembership.get(subscript);
            if (!(candidate.equals((Object)dataOwner) || buddies.contains(candidate) || ignoreColocatedBuddiesForSession && this.isColocated(candidate, dataOwner) || !this.isInSameBuddyPool(buddyPoolMap, candidate, dataOwner))) {
                buddies.add(candidate);
            }
            ++i;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Selected buddy group as " + buddies));
        }
        return buddies;
    }

    private boolean isInSameBuddyPool(Map buddyPoolMap, Object candidate, Object dataOwner) {
        if (buddyPoolMap == null) {
            return true;
        }
        Object ownerPoolName = buddyPoolMap.get(dataOwner);
        Object candidatePoolName = buddyPoolMap.get(candidate);
        if (ownerPoolName == null || candidatePoolName == null) {
            return false;
        }
        return ownerPoolName.equals(candidatePoolName);
    }

    private boolean isColocated(IpAddress candidate, IpAddress dataOwner) {
        block6: {
            InetAddress inetD;
            InetAddress inetC = candidate.getIpAddress();
            if (inetC.equals(inetD = dataOwner.getIpAddress())) {
                return true;
            }
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface i = nics.nextElement();
                    Enumeration<InetAddress> addrs = i.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress addr = addrs.nextElement();
                        if (!addr.equals(inetC)) continue;
                        return true;
                    }
                }
            }
            catch (SocketException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Unable to read NICs on host", (Throwable)e);
                }
                if (!this.log.isInfoEnabled()) break block6;
                this.log.info((Object)("UNable to read all network interfaces on host " + inetD + " to determine colocation of " + inetC + ".  Assuming " + inetC + " is NOT colocated with " + inetD));
            }
        }
        return false;
    }
}

