/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.InputStream;
import java.io.OutputStream;
import mazz.i18n.Logger;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.agent.AgentServiceLifecycleListener;
import org.rhq.core.pc.agent.AgentServiceStreamRemoter;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.ServiceContainer;
import org.rhq.enterprise.communications.command.client.RemoteInputStream;
import org.rhq.enterprise.communications.command.client.RemoteOutputStream;

public class AgentServiceRemoter
implements AgentServiceLifecycleListener,
AgentServiceStreamRemoter {
    private static final Logger LOG = AgentI18NFactory.getLogger(AgentServiceRemoter.class);
    private final AgentMain m_agent;

    public AgentServiceRemoter(AgentMain agent) {
        this.m_agent = agent;
    }

    public void started(AgentService agent_service) {
        LOG.debug("AgentServiceRemoting.remoting-agent-service", new Object[]{agent_service.getClass().getName(), agent_service.getClientInterface().getName()});
        try {
            ServiceContainer comm_services = this.m_agent.getServiceContainer();
            if (comm_services == null) {
                throw new IllegalStateException();
            }
            comm_services.addRemotePojo((Object)agent_service, agent_service.getClientInterface());
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "AgentServiceRemoting.error-remoting-agent-service", new Object[]{agent_service.getClass().getName(), agent_service.getClientInterface().getName()});
        }
    }

    public void stopped(AgentService agent_service) {
        LOG.debug("AgentServiceRemoting.unremoting-agent-service", new Object[]{agent_service.getClass().getName(), agent_service.getClientInterface().getName()});
        ServiceContainer comm_services = this.m_agent.getServiceContainer();
        if (comm_services != null) {
            comm_services.removeRemotePojo(agent_service.getClientInterface());
        }
    }

    public InputStream prepareInputStream(InputStream stream) {
        if (stream == null) {
            return null;
        }
        try {
            ServiceContainer sc = this.m_agent.getServiceContainer();
            if (sc == null) {
                return stream;
            }
            return new RemoteInputStream(stream, sc);
        }
        catch (Exception e) {
            throw new RuntimeException(this.m_agent.getI18NMsg().getMsg("AgentServiceRemoting.failed-to-remote-stream", new Object[0]), e);
        }
    }

    public OutputStream prepareOutputStream(OutputStream stream) {
        if (stream == null) {
            return null;
        }
        try {
            ServiceContainer sc = this.m_agent.getServiceContainer();
            if (sc == null) {
                return stream;
            }
            return new RemoteOutputStream(stream, sc);
        }
        catch (Exception e) {
            throw new RuntimeException(this.m_agent.getI18NMsg().getMsg("AgentServiceRemoting.failed-to-remote-outstream", new Object[0]), e);
        }
    }
}

