/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.util.Stack;

public class ThreadPool {
    private final Stack pool = new Stack();
    private int maxSize = 10;
    private boolean enabled = false;

    public synchronized void enable() {
        this.enabled = true;
    }

    public synchronized void disable() {
        this.enabled = false;
        while (!this.pool.isEmpty()) {
            Worker w = (Worker)this.pool.pop();
            w.die();
        }
    }

    public void setMaximumSize(int size) {
        this.maxSize = size;
    }

    public synchronized void run(Runnable work) {
        if (this.pool.size() == 0) {
            new Worker(work);
        } else {
            Worker w = (Worker)this.pool.pop();
            w.run(work);
        }
    }

    private synchronized void returnWorker(Worker w) {
        if (this.enabled && this.pool.size() < this.maxSize) {
            this.pool.push(w);
        } else {
            w.die();
        }
    }

    class Worker
    extends Thread {
        boolean running = true;
        Runnable work;

        Worker(Runnable work) {
            this.work = work;
            this.setDaemon(true);
            this.start();
        }

        public synchronized void die() {
            this.running = false;
            this.notify();
        }

        public synchronized void run(Runnable work) {
            if (this.work != null) {
                throw new IllegalStateException("Worker already has work to do.");
            }
            this.work = work;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.running) {
                if (this.work != null) {
                    try {
                        this.work.run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.work = null;
                }
                ThreadPool.this.returnWorker(this);
                Worker worker = this;
                synchronized (worker) {
                    while (this.running && this.work == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }
}

