/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.demos.DrawCommand;
import org.jgroups.util.Util;

public class Draw2Channels
implements ActionListener {
    private final String control_groupname = "Draw2ChannelsGroup-Control";
    private final String data_groupname = "Draw2ChannelsGroup-Data";
    private Channel control_channel = null;
    private Channel data_channel = null;
    String control_props = null;
    String data_props = null;
    private Receiver control_receiver = null;
    private Receiver data_receiver = null;
    private int member_size = 1;
    final boolean first = true;
    final boolean cummulative = true;
    private JFrame mainFrame = null;
    private JPanel sub_panel = null;
    private DrawPanel panel = null;
    private JButton clear_button;
    private JButton leave_button;
    private final Random random = new Random(System.currentTimeMillis());
    private final Font default_font = new Font("Helvetica", 0, 12);
    private final Color draw_color = this.selectColor();
    private final Color background_color = Color.white;
    boolean no_channel = false;
    static /* synthetic */ Class class$org$jgroups$demos$DrawCommand;

    public Draw2Channels(String control_props, String data_props, boolean no_channel) throws Exception {
        this.control_props = control_props;
        this.data_props = data_props;
        this.no_channel = no_channel;
    }

    public static void main(String[] args) {
        Draw2Channels draw = null;
        String control_props = null;
        String data_props = null;
        boolean no_channel = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                Draw2Channels.help();
                return;
            }
            if (!"-no_channel".equals(args[i])) {
                Draw2Channels.help();
                return;
            }
            no_channel = true;
        }
        control_props = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
        data_props = "UDP(mcast_addr=224.10.10.200;mcast_port=5679)";
        try {
            draw = new Draw2Channels(control_props, data_props, no_channel);
            draw.go();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(0);
        }
    }

    static void help() {
        System.out.println("Draw2Channels [-help] [-no_channel]");
    }

    private Color selectColor() {
        int red = Math.abs(this.random.nextInt()) % 255;
        int green = Math.abs(this.random.nextInt()) % 255;
        int blue = Math.abs(this.random.nextInt()) % 255;
        return new Color(red, green, blue);
    }

    public void go() {
        try {
            if (!this.no_channel) {
                this.control_receiver = new ControlReceiver();
                this.data_receiver = new DataReceiver();
                System.out.println("Creating control channel");
                this.control_channel = new JChannel(this.control_props);
                this.control_channel.setReceiver(this.control_receiver);
                System.out.println("Creating data channel");
                this.data_channel = new JChannel(this.data_props);
                this.data_channel.setReceiver(this.data_receiver);
                System.out.println("Connecting data channel");
                this.data_channel.connect("Draw2ChannelsGroup-Data");
                System.out.println("Connecting control channel");
                this.control_channel.connect("Draw2ChannelsGroup-Control");
            }
            this.mainFrame = new JFrame();
            this.mainFrame.setDefaultCloseOperation(3);
            this.panel = new DrawPanel();
            this.panel.setBackground(this.background_color);
            this.sub_panel = new JPanel();
            this.mainFrame.getContentPane().add("Center", this.panel);
            this.clear_button = new JButton("Clear");
            this.clear_button.setFont(this.default_font);
            this.clear_button.addActionListener(this);
            this.leave_button = new JButton("Leave & Exit");
            this.leave_button.setFont(this.default_font);
            this.leave_button.addActionListener(this);
            this.sub_panel.add("South", this.clear_button);
            this.sub_panel.add("South", this.leave_button);
            this.mainFrame.getContentPane().add("South", this.sub_panel);
            this.mainFrame.setVisible(true);
            this.mainFrame.setBackground(this.background_color);
            this.clear_button.setForeground(Color.blue);
            this.leave_button.setForeground(Color.blue);
            this.setTitle();
            this.mainFrame.pack();
            this.mainFrame.setLocation(15, 25);
            this.mainFrame.setVisible(true);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    void setTitle() {
        String title = "";
        if (this.no_channel) {
            this.mainFrame.setTitle(" Draw Demo ");
            return;
        }
        if (this.control_channel.getLocalAddress() != null) {
            title = title + this.control_channel.getLocalAddress();
        }
        title = title + " (" + this.member_size + ") mbrs";
        this.mainFrame.setTitle(title);
    }

    public void clearPanel() {
        if (this.panel != null) {
            this.panel.clear();
        }
    }

    public void sendClearPanelMsg() {
        int[] tmp = new int[]{0};
        DrawCommand comm = new DrawCommand(2);
        try {
            byte[] buf = Util.streamableToByteBuffer(comm);
            this.data_channel.send(new Message(null, null, buf));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Clear".equals(command)) {
            if (this.no_channel) {
                this.clearPanel();
                return;
            }
            this.sendClearPanelMsg();
        } else if ("Leave & Exit".equals(command)) {
            if (!this.no_channel) {
                try {
                    this.control_channel.close();
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                try {
                    this.data_channel.close();
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            }
            this.mainFrame.setVisible(false);
            this.mainFrame.dispose();
            System.exit(0);
        } else {
            System.out.println("Unknown action");
        }
    }

    class DataReceiver
    extends ExtendedReceiverAdapter
    implements ChannelListener {
        DataReceiver() {
        }

        public void receive(Message msg) {
            byte[] buf = msg.getRawBuffer();
            DrawCommand comm = null;
            try {
                comm = (DrawCommand)Util.streamableFromByteBuffer(class$org$jgroups$demos$DrawCommand == null ? (class$org$jgroups$demos$DrawCommand = Draw2Channels.class$("org.jgroups.demos.DrawCommand")) : class$org$jgroups$demos$DrawCommand, buf, msg.getOffset(), msg.getLength());
                switch (comm.mode) {
                    case 1: {
                        if (Draw2Channels.this.panel != null) {
                            Draw2Channels.this.panel.drawPoint(comm);
                        }
                        break;
                    }
                    case 2: {
                        Draw2Channels.this.clearPanel();
                        break;
                    }
                    default: {
                        System.err.println("***** Draw2Channels.run(): received invalid draw command " + comm.mode);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void viewAccepted(View v) {
            System.out.println("** View=" + v);
            Draw2Channels.this.member_size = v.size();
            if (Draw2Channels.this.mainFrame != null) {
                Draw2Channels.this.setTitle();
            }
        }

        public void channelConnected(Channel channel) {
        }

        public void channelDisconnected(Channel channel) {
        }

        public void channelClosed(Channel channel) {
        }

        public void channelShunned() {
            System.out.println("received EXIT, waiting for ChannelReconnected callback");
        }

        public void channelReconnected(Address addr) {
        }
    }

    class ControlReceiver
    extends ExtendedReceiverAdapter {
        ControlReceiver() {
        }

        public void viewAccepted(View v) {
            Draw2Channels.this.member_size = v.size();
            if (Draw2Channels.this.mainFrame != null) {
                Draw2Channels.this.mainFrame.setTitle(Draw2Channels.this.member_size + " mbrs");
            }
            Draw2Channels.this.data_channel.down(new Event(6, v));
        }
    }

    private class DrawPanel
    extends JPanel
    implements MouseMotionListener {
        final Dimension preferred_size = new Dimension(235, 170);
        Image img = null;
        Dimension d;
        Dimension imgsize;
        Graphics gr = null;

        public DrawPanel() {
            this.addMouseMotionListener(this);
            this.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ DrawPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void componentResized(ComponentEvent e) {
                    if (this.this$1.getWidth() <= 0 || this.this$1.getHeight() <= 0) {
                        return;
                    }
                    this.this$1.createOffscreenImage();
                }
            });
        }

        void createOffscreenImage() {
            this.d = this.getSize();
            if (this.img == null || this.imgsize == null || this.imgsize.width != this.d.width || this.imgsize.height != this.d.height) {
                this.img = this.createImage(this.d.width, this.d.height);
                this.gr = this.img.getGraphics();
                this.imgsize = this.d;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            DrawCommand comm = new DrawCommand(1, x, y, Draw2Channels.this.draw_color.getRed(), Draw2Channels.this.draw_color.getGreen(), Draw2Channels.this.draw_color.getBlue());
            if (Draw2Channels.this.no_channel) {
                this.drawPoint(comm);
                return;
            }
            try {
                byte[] buf = Util.streamableToByteBuffer(comm);
                Draw2Channels.this.data_channel.send(new Message(null, null, buf));
                Thread.yield();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }

        public void drawPoint(DrawCommand c) {
            if (c == null) {
                return;
            }
            this.gr.setColor(new Color(c.r, c.g, c.b));
            this.gr.fillOval(c.x, c.y, 10, 10);
            this.repaint();
        }

        public void clear() {
            this.gr.clearRect(0, 0, this.getSize().width, this.getSize().height);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return this.preferred_size;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, null);
            }
        }
    }
}

