/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ApplicationConfig;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Initable;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleResourceFactory
implements ResourceFactory,
Initable {
    private Logger log = LoggerFactory.getLogger(MultipleResourceFactory.class);
    private final List<ResourceFactory> factories = new ArrayList<ResourceFactory>();

    public Resource getResource(String host, String url) {
        for (ResourceFactory rf : this.factories) {
            Resource r = rf.getResource(host, url);
            if (r == null) continue;
            return r;
        }
        this.log.debug("no resource factory supplied a resouce");
        return null;
    }

    public String getSupportedLevels() {
        String s = "1,2";
        for (ResourceFactory rf : this.factories) {
            String s2 = rf.getSupportedLevels();
            if (s2.length() >= s.length()) continue;
            return s2;
        }
        return s;
    }

    public void init(ApplicationConfig config, HttpManager manager) {
        String sFactories = config.getInitParameter("resource.factory.multiple");
        this.init(sFactories, config, manager);
    }

    protected void init(String sFactories, ApplicationConfig config, HttpManager manager) {
        String[] arr;
        this.log.debug("init: " + sFactories);
        for (String s : arr = sFactories.split(",")) {
            this.createFactory(s, config, manager);
        }
    }

    private void createFactory(String s, ApplicationConfig config, HttpManager manager) {
        Object o;
        Class<?> c;
        this.log.debug("createFactory: " + s);
        try {
            c = Class.forName(s);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(s, ex);
        }
        try {
            o = c.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(s, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(s, ex);
        }
        ResourceFactory rf = (ResourceFactory)o;
        if (rf instanceof Initable) {
            Initable i = (Initable)rf;
            i.init(config, manager);
        }
        this.factories.add(rf);
    }

    public void destroy(HttpManager manager) {
        if (this.factories == null) {
            this.log.warn("factories is null");
            return;
        }
        for (ResourceFactory f : this.factories) {
            if (!(f instanceof Initable)) continue;
            ((Initable)f).destroy(manager);
        }
    }
}

