/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.AbstractResponse;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletResponse
extends AbstractResponse {
    private static final Logger log = LoggerFactory.getLogger(ServletResponse.class);
    private static ThreadLocal<HttpServletResponse> tlResponse = new ThreadLocal();
    private final HttpServletResponse r;
    private Response.Status status;
    private Map<String, String> headers = new HashMap<String, String>();

    public static HttpServletResponse getResponse() {
        return tlResponse.get();
    }

    public ServletResponse(HttpServletResponse r) {
        this.r = r;
        tlResponse.set(r);
    }

    protected void setAnyDateHeader(Response.Header name, Date date) {
        this.r.setDateHeader(name.code, date.getTime());
    }

    public String getNonStandardHeader(String code) {
        return this.headers.get(code);
    }

    public void setNonStandardHeader(String name, String value) {
        this.r.addHeader(name, value);
        this.headers.put(name, value);
    }

    public void setStatus(Response.Status status) {
        this.r.setStatus(status.code);
        this.status = status;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public OutputStream getOutputStream() {
        try {
            return this.r.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() {
        try {
            this.r.flushBuffer();
            this.r.getOutputStream().flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void sendRedirect(String url) {
        String u = this.r.encodeRedirectURL(url);
        try {
            this.r.sendRedirect(u);
        }
        catch (IOException ex) {
            log.warn("exception sending redirect", (Throwable)ex);
        }
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }
}

