/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.rhq.augeas.config.AugeasConfiguration;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.util.Glob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AugeasConfigurationSimple
implements AugeasConfiguration {
    private String loadPath;
    private int mode;
    private String rootPath;
    private List<AugeasModuleConfig> modules = new ArrayList<AugeasModuleConfig>();

    public void setLoadPath(String loadPath) {
        this.loadPath = loadPath;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setModules(List<AugeasModuleConfig> modules) {
        this.modules = modules;
    }

    @Override
    public String getLoadPath() {
        return this.loadPath;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public List<AugeasModuleConfig> getModules() {
        return this.modules;
    }

    @Override
    public String getRootPath() {
        return this.rootPath;
    }

    public void addModuleConfig(AugeasModuleConfig config) {
        if (this.modules.contains(config)) {
            return;
        }
        this.modules.add(config);
    }

    @Override
    public AugeasModuleConfig getModuleByName(String name) {
        for (AugeasModuleConfig module : this.modules) {
            if (!module.getModuletName().equals(name)) continue;
            return module;
        }
        return null;
    }

    @Override
    public void loadFiles() {
        File root = new File(this.getRootPath());
        for (AugeasModuleConfig module : this.modules) {
            List<String> includeGlobs = module.getIncludedGlobs();
            if (includeGlobs.size() <= 0) {
                throw new IllegalStateException("Expecting at least once inclusion pattern for configuration files.");
            }
            List<File> files = Glob.matchAll(root, includeGlobs);
            if (module.getExcludedGlobs() != null) {
                List<String> excludeGlobs = module.getExcludedGlobs();
                Glob.excludeAll(files, excludeGlobs);
            }
            for (File configFile : files) {
                if (!configFile.isAbsolute()) {
                    throw new IllegalStateException("Configuration files inclusion patterns contain a non-absolute file.");
                }
                if (!configFile.exists()) {
                    throw new IllegalStateException("Configuration files inclusion patterns refer to a non-existent file.");
                }
                if (configFile.isDirectory()) {
                    throw new IllegalStateException("Configuration files inclusion patterns refer to a directory.");
                }
                if (module.getConfigFiles().contains(configFile.getAbsolutePath())) continue;
                module.addConfigFile(configFile.getAbsolutePath());
            }
        }
    }
}

