/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.Ping;
import org.rhq.enterprise.communications.PingImpl;
import org.rhq.enterprise.communications.command.impl.echo.server.EchoCommandService;
import org.rhq.enterprise.communications.command.impl.identify.server.IdentifyCommandService;
import org.rhq.enterprise.communications.command.server.CommandAuthenticator;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class ServiceContainerConfiguration {
    private static final Logger LOG = CommI18NFactory.getLogger(ServiceContainerConfiguration.class);
    private final Preferences m_preferences;

    public ServiceContainerConfiguration(Preferences prefs) {
        if (prefs == null) {
            throw new IllegalArgumentException("prefs=null");
        }
        this.m_preferences = prefs;
    }

    public Preferences getPreferences() {
        return this.m_preferences;
    }

    public int getServiceContainerConfigurationVersion() {
        int value = this.m_preferences.getInt("rhq.communications.configuration-schema-version", 0);
        return value;
    }

    public void tagWithServiceContainerConfigurationVersion() {
        this.m_preferences.putInt("rhq.communications.configuration-schema-version", 1);
        this.flush("rhq.communications.configuration-schema-version");
    }

    public int getGlobalConcurrencyLimit() {
        int value = this.m_preferences.getInt("rhq.communications.global-concurrency-limit", 0);
        return value;
    }

    public String getMBeanServerName() {
        String value = this.m_preferences.get("rhq.communications.service-container.mbean-server-name", null);
        return value;
    }

    public boolean isCommunicationsDisabled() {
        boolean value = this.m_preferences.getBoolean("rhq.communications.disable-communications", false);
        return value;
    }

    public File getDataDirectory() {
        String dirStr = this.m_preferences.get("rhq.communications.data-directory", "data");
        File dir = new File(dirStr);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public String getDataDirectoryIfDefined() {
        String dir_str = this.m_preferences.get("rhq.communications.data-directory", null);
        return dir_str;
    }

    public boolean isMulticastDetectorEnabled() {
        boolean value = this.m_preferences.getBoolean("rhq.communications.multicast-detector.enabled", false);
        return value;
    }

    public String getMulticastDetectorMulticastAddress() {
        String value = this.m_preferences.get("rhq.communications.multicast-detector.multicast-address", null);
        return value;
    }

    public String getMulticastDetectorBindAddress() {
        String value = this.m_preferences.get("rhq.communications.multicast-detector.bind-address", null);
        return value;
    }

    public long getMulticastDetectorDefaultTimeDelay() {
        long value = this.m_preferences.getLong("rhq.communications.multicast-detector.default-time-delay", Long.MIN_VALUE);
        return value;
    }

    public long getMulticastDetectorHeartbeatTimeDelay() {
        long value = this.m_preferences.getLong("rhq.communications.multicast-detector.heartbeat-time-delay", Long.MIN_VALUE);
        return value;
    }

    public int getMulticastDetectorPort() {
        int value = this.m_preferences.getInt("rhq.communications.multicast-detector.port", Integer.MIN_VALUE);
        return value;
    }

    public String getConnectorRHQType() {
        String value = this.m_preferences.get("rhq.communications.connector.rhqtype", "agent");
        return value;
    }

    public String getConnectorTransport() {
        String value = this.m_preferences.get("rhq.communications.connector.transport", "socket");
        return value;
    }

    public String getConnectorBindAddress() {
        String defaultBindAddress;
        try {
            defaultBindAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            defaultBindAddress = "127.0.0.1";
        }
        String value = this.m_preferences.get("rhq.communications.connector.bind-address", defaultBindAddress);
        return value;
    }

    public int getConnectorBindPort() {
        int value = this.m_preferences.getInt("rhq.communications.connector.bind-port", 16163);
        return value;
    }

    public String getConnectorTransportParams() {
        String value = this.m_preferences.get("rhq.communications.connector.transport-params", "numAcceptThreads=1&maxPoolSize=303&clientMaxPoolSize=304&socketTimeout=60000&enableTcpNoDelay=true&backlog=200");
        return value;
    }

    public String getConnectorRemoteEndpoint() {
        String rhqtype = this.getConnectorRHQType();
        if (!rhqtype.equals("agent") && !rhqtype.equals("server")) {
            LOG.warn("ServiceContainer.invalid-rhqtype", new Object[]{rhqtype, "server", "agent"});
            rhqtype = "agent";
        }
        String rhqtype_param = "rhq.communications.connector.rhqtype=" + rhqtype;
        String transport = this.getConnectorTransport();
        String bind_address = this.getConnectorBindAddress();
        int bind_port = this.getConnectorBindPort();
        String transport_params = this.getConnectorTransportParams().trim();
        String locator_uri = transport + "://" + bind_address + ":" + bind_port;
        transport_params = transport_params.length() == 0 ? "/?" + rhqtype_param : (transport_params.startsWith("/") ? (transport_params.indexOf(63) == -1 ? transport_params + "?" + rhqtype_param : transport_params + "&" + rhqtype_param) : "/?" + rhqtype_param + "&" + transport_params);
        locator_uri = locator_uri + transport_params;
        return locator_uri;
    }

    public long getConnectorLeasePeriod() {
        long value = this.m_preferences.getLong("rhq.communications.connector.lease-period", Long.MIN_VALUE);
        return value;
    }

    public String getConnectorSecuritySocketProtocol() {
        String value = this.m_preferences.get("rhq.communications.connector.security.secure-socket-protocol", "TLS");
        return value;
    }

    public String getConnectorSecurityClientAuthMode() {
        String value = this.m_preferences.get("rhq.communications.connector.security.client-auth-mode", "none");
        if (value.equalsIgnoreCase("true")) {
            value = "need";
        } else if (value.equalsIgnoreCase("false")) {
            value = "none";
        }
        if (!(value.equals("none") || value.equals("want") || value.equals("need"))) {
            LOG.warn("ServiceContainerConfiguration.invalid-client-auth", new Object[]{"rhq.communications.connector.security.client-auth-mode", value, "none", "want", "need", "need"});
            value = "need";
        }
        return value;
    }

    public String getConnectorSecurityKeystoreFile() {
        String value = this.m_preferences.get("rhq.communications.connector.security.keystore.file", null);
        if (value == null) {
            value = new File(this.getDataDirectory(), "keystore.dat").getAbsolutePath();
        }
        return value;
    }

    public String getConnectorSecurityKeystoreAlgorithm() {
        String value = this.m_preferences.get("rhq.communications.connector.security.keystore.algorithm", "SunX509");
        return value;
    }

    public String getConnectorSecurityKeystoreType() {
        String value = this.m_preferences.get("rhq.communications.connector.security.keystore.type", "JKS");
        return value;
    }

    public String getConnectorSecurityKeystorePassword() {
        String value = this.m_preferences.get("rhq.communications.connector.security.keystore.password", "rhqpwd");
        return value;
    }

    public String getConnectorSecurityKeystoreKeyPassword() {
        String value = this.m_preferences.get("rhq.communications.connector.security.keystore.key-password", null);
        if (value == null) {
            value = this.getConnectorSecurityKeystorePassword();
        }
        return value;
    }

    public String getConnectorSecurityKeystoreAlias() {
        String value = this.m_preferences.get("rhq.communications.connector.security.keystore.alias", "rhq");
        return value;
    }

    public String getConnectorSecurityTruststoreFile() {
        String value = this.m_preferences.get("rhq.communications.connector.security.truststore.file", null);
        if (value == null) {
            value = new File(this.getDataDirectory(), "truststore.dat").getAbsolutePath();
        }
        return value;
    }

    public String getConnectorSecurityTruststoreAlgorithm() {
        String value = this.m_preferences.get("rhq.communications.connector.security.truststore.algorithm", "SunX509");
        return value;
    }

    public String getConnectorSecurityTruststoreType() {
        String value = this.m_preferences.get("rhq.communications.connector.security.truststore.type", "JKS");
        return value;
    }

    public String getConnectorSecurityTruststorePassword() {
        String value = this.m_preferences.get("rhq.communications.connector.security.truststore.password", null);
        return value;
    }

    public String getStartupCommandServices() {
        String value = this.m_preferences.get("rhq.communications.command-services", EchoCommandService.class.getName() + "," + IdentifyCommandService.class.getName());
        return value;
    }

    public String getStartupRemotePojos() {
        String value = this.m_preferences.get("rhq.communications.remote-pojos", PingImpl.class.getName() + ":" + Ping.class.getName());
        return value;
    }

    public long getRemoteStreamMaxIdleTime() {
        long value = this.m_preferences.getLong("rhq.communications.remote-stream-max-idle-time-msecs", 300000L);
        return value;
    }

    public boolean isCommandServiceDirectoryDynamicDiscoveryEnabled() {
        boolean value = this.m_preferences.getBoolean("rhq.communications.command-service-directory.allow-dynamic-discovery", true);
        return value;
    }

    public CommandAuthenticator getCommandAuthenticator() throws Exception {
        CommandAuthenticator obj = null;
        String value = this.m_preferences.get("rhq.communications.command-authenticator", "");
        if (value != null && value.length() > 0) {
            obj = (CommandAuthenticator)Class.forName(value).newInstance();
        }
        return obj;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.m_preferences.absolutePath());
        buf.append('[');
        try {
            String[] keys = this.m_preferences.keys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                buf.append(key);
                buf.append('=');
                buf.append(this.m_preferences.get(key, LOG.getMsgString("ServiceContainerConfiguration.unknown", new Object[0])));
                if (i + 1 >= keys.length) continue;
                buf.append(',');
            }
        }
        catch (BackingStoreException e) {
            buf.append('<');
            buf.append(LOG.getMsgString("ServiceContainerConfiguration.cannot-get-prefs", new Object[]{e}));
            buf.append('>');
        }
        buf.append(']');
        return buf.toString();
    }

    private void flush(String changedPreference) {
        try {
            this.m_preferences.flush();
        }
        catch (Exception e) {
            LOG.warn(LOG.getMsgString("ServiceContainerConfiguration.cannot-store-preferences", new Object[0]), new Object[]{changedPreference, e});
        }
    }
}

