/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.util.prefs;

import java.net.InetAddress;
import org.rhq.enterprise.communications.util.prefs.InetAddressSetupValidityChecker;
import org.rhq.enterprise.communications.util.prefs.SetupInstruction;
import org.rhq.enterprise.communications.util.prefs.SetupValidityChecker;

public class LocalInetHostnameSetupInstruction
extends SetupInstruction {
    private static final String GET_PREF_DEFAULT_MARKER = ":*default*:";

    public LocalInetHostnameSetupInstruction(String preference_name, SetupValidityChecker validity_checker, String prompt_message, String help_message) throws IllegalArgumentException {
        super(preference_name, GET_PREF_DEFAULT_MARKER, validity_checker, prompt_message, help_message, false);
    }

    public LocalInetHostnameSetupInstruction(String preference_name, String prompt_message, String help_message) throws IllegalArgumentException {
        super(preference_name, null, new InetAddressSetupValidityChecker(), prompt_message, help_message, false);
    }

    public void preProcess() {
        super.preProcess();
        String current_value = null;
        if (GET_PREF_DEFAULT_MARKER.equals(this.getDefaultValue())) {
            current_value = this.getPreferences().get(this.getPreferenceName(), null);
            this.setDefaultValue(current_value);
        }
        if (current_value == null) {
            try {
                this.setDefaultValue(InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (Exception e) {
                this.setDefaultValue("localhost");
            }
        }
    }
}

