/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.txlock;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.txlock.QueuedTxLock;
import org.jboss.aspects.txlock.TxLockInterceptor;

public class TxLockInterceptorFactory
implements AspectFactory {
    private static TransactionManager getTransactionManager() {
        try {
            InitialContext ctx = new InitialContext();
            TransactionManager tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
            return tm;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public Object createPerVM() {
        throw new RuntimeException("this interceptor only supports PER_CLASS and PER_INSTANCE");
    }

    public Object createPerClass(Advisor advisor) {
        QueuedTxLock lock = new QueuedTxLock();
        advisor.getClassMetaData().addMetaData((Object)"TxLock", (Object)"TxLock", (Object)lock, PayloadKey.TRANSIENT);
        return new TxLockInterceptor(TxLockInterceptorFactory.getTransactionManager(), lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        SimpleMetaData instanceData = instanceAdvisor.getMetaData();
        QueuedTxLock lock = null;
        SimpleMetaData simpleMetaData = instanceData;
        synchronized (simpleMetaData) {
            lock = (QueuedTxLock)instanceData.getMetaData((Object)"TxLock", (Object)"TxLock");
            if (lock == null) {
                lock = new QueuedTxLock();
                instanceData.addMetaData((Object)"TxLock", (Object)"TxLock", (Object)lock, PayloadKey.TRANSIENT);
            }
        }
        return new TxLockInterceptor(TxLockInterceptorFactory.getTransactionManager(), lock);
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        throw new RuntimeException("this interceptor only supports PER_CLASS and PER_INSTANCE");
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        throw new RuntimeException("this interceptor only supports PER_CLASS and PER_INSTANCE");
    }

    public String getName() {
        return this.getClass().getName();
    }
}

