/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.www.snmp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.www.snmp.SNMPCacheObject;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;

class SNMPSessionCache
implements InvocationHandler {
    private SNMPSession session;
    private Map columnCache = new HashMap();
    private Map bulkCache = new HashMap();
    private Map tableCache = new HashMap();
    private final Log log = LogFactory.getLog(this.getClass());
    public static final int EXPIRE_DEFAULT = 30000;
    private int expire;

    SNMPSessionCache(SNMPSession session, int expire) {
        this.session = session;
        this.expire = expire;
    }

    static SNMPSession newInstance(SNMPSession session, int expire) throws SNMPException {
        SNMPSession sessionCache;
        SNMPSessionCache handler = new SNMPSessionCache(session, expire);
        try {
            sessionCache = (SNMPSession)Proxy.newProxyInstance(SNMPSession.class.getClassLoader(), new Class[]{SNMPSession.class}, (InvocationHandler)handler);
        }
        catch (Exception e) {
            throw new SNMPException(e.getMessage());
        }
        return sessionCache;
    }

    private SNMPCacheObject getFromCache(long timeNow, Map cache, String name, Object arg) {
        SNMPCacheObject cacheVal = (SNMPCacheObject)cache.get(arg);
        String argDebug = "";
        if (this.log.isDebugEnabled()) {
            argDebug = " with arg=" + arg;
        }
        if (cacheVal == null) {
            cacheVal = new SNMPCacheObject();
            cacheVal.expire = this.expire;
            cache.put(arg, cacheVal);
        } else if (timeNow - cacheVal.timestamp > (long)cacheVal.expire) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("expiring " + name + " from cache" + argDebug));
            }
            cacheVal.value = null;
        }
        return cacheVal;
    }

    private StringBuffer invokerToString(String name, Object[] args, Object cacheKey) {
        StringBuffer invoker = new StringBuffer(name);
        invoker.append('(');
        if (args != null && args.length != 0) {
            String arg = args[0].toString();
            invoker.append(arg);
            for (int i = 1; i < args.length; ++i) {
                invoker.append('.').append(args[i]);
            }
            if (cacheKey != null && !arg.equals(cacheKey)) {
                invoker.append('/').append(cacheKey);
            }
        }
        invoker.append(')');
        return invoker;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws SNMPException {
        Object retval;
        SNMPCacheObject cacheVal = null;
        Map cache = null;
        Object cacheKey = null;
        String name = method.getName();
        long timeNow = 0L;
        if (name.equals("getBulk")) {
            cache = this.bulkCache;
            cacheKey = args[0];
        } else if (name.equals("getTable")) {
            cache = this.tableCache;
            cacheKey = args[0].hashCode() ^ args[1].hashCode();
        } else if (name.equals("getColumn")) {
            cache = this.columnCache;
            cacheKey = args[0];
        }
        if (cache != null) {
            timeNow = System.currentTimeMillis();
            cacheVal = this.getFromCache(timeNow, cache, name, cacheKey);
            if (cacheVal.value != null) {
                return cacheVal.value;
            }
        }
        try {
            retval = method.invoke((Object)this.session, args);
        }
        catch (InvocationTargetException e) {
            SNMPException snmpException;
            Throwable t = e.getTargetException();
            if (t instanceof SNMPException) {
                snmpException = (SNMPException)t;
            } else {
                String msg = t + " (while invoking: " + this.invokerToString(name, args, cacheKey) + ")";
                snmpException = new SNMPException(msg);
            }
            throw snmpException;
        }
        catch (Exception e) {
            String msg = e + " (while invoking: " + this.invokerToString(name, args, cacheKey) + ")";
            throw new SNMPException(msg);
        }
        if (cacheVal != null) {
            cacheVal.value = retval;
            cacheVal.timestamp = timeNow;
        }
        return retval;
    }
}

