/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.util.Collection;
import java.util.List;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.setup.Column;
import org.rhq.core.db.setup.Table;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class SQLServerColumn
extends Column {
    protected SQLServerColumn(Node node, Table table) throws SAXException {
        super(node, table);
    }

    protected String getCreateCommand(List cmds, Collection typemaps, DatabaseType dbtype) {
        String defaultValue = this.getsDefault();
        if (defaultValue != null) {
            if (defaultValue.equalsIgnoreCase("TRUE")) {
                this.m_sDefault = "1";
            } else if (defaultValue.equalsIgnoreCase("FALSE")) {
                this.m_sDefault = "0";
            }
        }
        return super.getCreateCommand(cmds, typemaps, dbtype);
    }

    protected String getOnDelete() {
        if (this.m_strTableName.equalsIgnoreCase(this.getReferences())) {
            return null;
        }
        return super.getOnDelete();
    }

    protected String getSizeCommand(List cmds) {
        if (this.getType().equals("CLOB")) {
            return "";
        }
        if (this.getType().equals("VARCHAR2") && this.getSize() > 8000) {
            return "(MAX)";
        }
        return super.getSizeCommand(cmds);
    }

    protected void getPostCreateCommands(List cmds) {
        if (this.getType().equals("VARCHAR2") && this.getSize() > 8000) {
            String table = this.m_strTableName.toUpperCase();
            String column = this.m_strName.toUpperCase();
            String constraintName = column + String.valueOf(this.getSize());
            cmds.add("ALTER TABLE " + table + " ADD CONSTRAINT " + constraintName + " CHECK DATALENGTH(" + column + ") <= " + this.getSize());
        }
    }

    protected String getDefaultCommand(List cmds) {
        String strCmd = "DEFAULT ";
        switch (this.getDefault()) {
            case 1: 
            case 3: {
                int seed = this.getIncrementSequence() > 0 ? this.getIncrementSequence() : 1;
                int increment = this.getIncrementSequence() > 0 ? this.getIncrementSequence() : 1;
                strCmd = "IDENTITY ( " + String.valueOf(seed) + ", " + String.valueOf(increment) + " )";
            }
        }
        return strCmd;
    }

    protected void getDropCommands(List cmds) {
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    cmds.add("sp_configure 'allow update', 1");
                    cmds.add("reconfigure with override");
                    cmds.add("update syscolumns set colstat = colstat - 1 where id = object_id('" + this.m_strTableName.toUpperCase() + "') " + "and name = '" + this.getName().toUpperCase() + "'");
                    cmds.add("exec sp_configure 'allow update', 0");
                    cmds.add("reconfigure with override");
                }
            }
        }
    }
}

