/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.twitter;

import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.twitter.TwitterComponent;
import org.rhq.plugins.twitter.TwitterEventPoller;
import twitter4j.Paging;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Tweet;
import twitter4j.Twitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedComponent
implements ResourceComponent<TwitterComponent>,
MeasurementFacet,
DeleteResourceFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final long NOT_YET_SET = 1L;
    public static final String TOPIC_EVENT = "FeedEvent";
    EventContext eventContext;
    private long lastId = 1L;
    private boolean isSearch = false;
    private String keyword;
    private TwitterEventPoller eventPoller;
    private String serverUrl;
    private String searchBase;

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void start(ResourceContext<TwitterComponent> context) throws InvalidPluginConfigurationException, Exception {
        Configuration conf = context.getPluginConfiguration();
        String kind = conf.getSimpleValue("kind", "user");
        if (kind.equals("search")) {
            this.isSearch = true;
        }
        this.keyword = conf.getSimpleValue("keyword", "Jopr");
        this.serverUrl = ((TwitterComponent)context.getParentResourceComponent()).getServerUrl();
        this.searchBase = ((TwitterComponent)context.getParentResourceComponent()).getSearchUrl();
        this.eventContext = context.getEventContext();
        this.eventPoller = new TwitterEventPoller(TOPIC_EVENT);
        this.eventContext.registerEventPoller((EventPoller)this.eventPoller, 63);
    }

    public void stop() {
        this.eventContext.unregisterEventPoller(TOPIC_EVENT);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            MeasurementDataNumeric res;
            if (!req.getName().equals("tweetCount")) continue;
            Twitter twitter = new Twitter(this.serverUrl);
            Paging paging = new Paging();
            if (this.isSearch) {
                twitter.setSearchBaseURL(this.searchBase);
                Query q = new Query(this.keyword);
                q.setSinceId(this.lastId);
                if (this.lastId == 1L) {
                    q.setRpp(1);
                } else {
                    q.setRpp(20);
                }
                QueryResult qr = twitter.search(q);
                List tweets = qr.getTweets();
                res = new MeasurementDataNumeric(req, Double.valueOf(tweets.size()));
                this.eventPoller.addTweets(tweets);
                if (tweets.size() > 0) {
                    this.lastId = ((Tweet)tweets.get(0)).getId();
                }
            } else {
                if (this.lastId == 1L) {
                    paging.setCount(1);
                } else {
                    paging.setCount(100);
                }
                paging.setSinceId(this.lastId);
                List statuses = twitter.getUserTimeline(this.keyword, paging);
                res = new MeasurementDataNumeric(req, Double.valueOf(statuses.size()));
                this.eventPoller.addStatuses(statuses);
                if (statuses.size() > 0) {
                    this.lastId = ((Status)statuses.get(0)).getId();
                }
            }
            report.addData(res);
        }
    }

    public void deleteResource() throws Exception {
        this.log.info((Object)"deleteResouces called");
    }
}

