/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.postgres.PostgresServerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresUserComponent
implements DatabaseComponent<PostgresServerComponent>,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet {
    private ResourceContext<PostgresServerComponent> resourceContext;

    public void start(ResourceContext<PostgresServerComponent> resourceContext) {
        this.resourceContext = resourceContext;
    }

    public void stop() {
        this.resourceContext = null;
    }

    public String getUserName() {
        return this.resourceContext.getPluginConfiguration().getSimpleValue("userName", null);
    }

    public AvailabilityType getAvailability() {
        if (DatabaseQueryUtility.getSingleNumericQueryValue((DatabaseComponent)this, (String)"SELECT COUNT(*) FROM PG_ROLES WHERE rolname = ?", (Object[])new Object[]{this.getUserName()}) == 1.0) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public Connection getConnection() {
        return ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public void removeConnection() {
        ((PostgresServerComponent)this.resourceContext.getParentResourceComponent()).removeConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Map values = DatabaseQueryUtility.getNumericQueryValues((DatabaseComponent)this, (String)"SELECT (SELECT COUNT(*) FROM pg_stat_activity where usename = ? AND current_query != '<IDLE>') AS active,\n  (SELECT COUNT(*) FROM pg_stat_activity WHERE usename = ?) AS total", (Object[])new Object[]{this.getUserName(), this.getUserName()});
        for (MeasurementScheduleRequest request : metrics) {
            report.addData(new MeasurementDataNumeric(request, (Double)values.get(request.getName())));
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.getConnection().prepareStatement("SELECT * FROM PG_ROLES WHERE rolname = ?");
            statement.setString(1, this.getUserName());
            rs = statement.executeQuery();
            rs.next();
            Configuration config = new Configuration();
            config.put((Property)new PropertySimple("user", (Object)rs.getString("rolname")));
            config.put((Property)new PropertySimple("canLogin", (Object)rs.getBoolean("rolcanlogin")));
            config.put((Property)new PropertySimple("inheritRights", (Object)rs.getBoolean("rolinherit")));
            config.put((Property)new PropertySimple("superuser", (Object)rs.getBoolean("rolsuper")));
            config.put((Property)new PropertySimple("canCreateDatabaseObjects", (Object)rs.getBoolean("rolcreatedb")));
            config.put((Property)new PropertySimple("canCreateRoles", (Object)rs.getBoolean("rolcreaterole")));
            config.put((Property)new PropertySimple("canModifyCatalogDirectly", (Object)rs.getBoolean("rolcatupdate")));
            config.put((Property)new PropertySimple("connectionLimit", (Object)rs.getInt("rolconnlimit")));
            configuration = config;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Statement)statement, rs);
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Statement)statement, (ResultSet)rs);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration config = report.getConfiguration();
        Statement statement = null;
        String sql = PostgresUserComponent.getUserSQL(config, UpdateType.ALTER);
        try {
            statement = this.getConnection().createStatement();
            int updates = statement.executeUpdate(sql);
            if (updates != 1) {
                report.setErrorMessage("Failed to update user " + config.getSimpleValue("user", null));
            } else {
                report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            }
        }
        catch (SQLException e) {
            report.setErrorMessageFromThrowable((Throwable)e);
        }
        finally {
            JDBCUtil.safeClose((Statement)statement);
        }
    }

    public static String getUserSQL(Configuration config, UpdateType type) {
        int connectionLimit = -1;
        PropertySimple connLimit = config.getSimple("connectionLimit");
        if (connLimit != null && connLimit.getIntegerValue() != null) {
            connectionLimit = connLimit.getIntegerValue();
        }
        String sql = type.name() + " USER " + config.getSimpleValue("user", null) + " ";
        if (type != UpdateType.DROP) {
            if (config.getSimpleValue("password", null) != null && config.getSimpleValue("password", null).length() != 0) {
                sql = sql + " WITH PASSWORD '" + config.getSimpleValue("password", null) + "' ";
            }
            sql = sql + (config.getSimple("canCreateDatabaseObjects").getBooleanValue() != false ? "CREATEDB " : "NOCREATEDB ");
            sql = sql + (config.getSimple("canCreateRoles").getBooleanValue() != false ? "CREATEUSER " : "NOCREATEUSER ");
            sql = sql + (connectionLimit > -1 ? "CONNECTION LIMIT " + connectionLimit : "");
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource() throws Exception {
        Statement statement = null;
        String sql = "DROP USER " + this.resourceContext.getResourceKey();
        try {
            statement = this.getConnection().createStatement();
            statement.executeUpdate(sql);
        }
        finally {
            JDBCUtil.safeClose((Statement)statement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateType {
        CREATE,
        ALTER,
        DROP;

    }
}

