/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mazz.i18n.Logger;
import mazz.i18n.Msg;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMap {
    private static final Logger LOG = DbUtilsI18NFactory.getLogger(TypeMap.class);
    private static final Msg MSG = DbUtilsI18NFactory.getMsg();
    private static final String DB_TYPEMAPS_XML_FILENAME = "db-typemaps.xml";
    private static final String TYPEMAP_ELEMENT = "typemap";
    private static final String TYPEMAP_MAP_ELEMENT = "map";
    private static final String DB_ATTRIBUTE = "db";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String JAVA_DATABASE_TYPE = "java";
    private String m_genericTypeName;
    private Hashtable<String, String> m_databaseTypeMap = new Hashtable();
    private static Collection<TypeMap> m_knownTypes;

    private TypeMap(Node typemap_node) throws SAXException {
        if (TypeMap.isTypeMap(typemap_node)) {
            NamedNodeMap typemap_node_attribs = typemap_node.getAttributes();
            for (int i_typemap_node_attrib = 0; i_typemap_node_attrib < typemap_node_attribs.getLength(); ++i_typemap_node_attrib) {
                Node typemap_attrib = typemap_node_attribs.item(i_typemap_node_attrib);
                String typemap_attrib_name = typemap_attrib.getNodeName();
                String typemap_attrib_value = typemap_attrib.getNodeValue();
                if (!TYPE_ATTRIBUTE.equalsIgnoreCase(typemap_attrib_name)) continue;
                this.m_genericTypeName = typemap_attrib_value;
                NodeList maps = typemap_node.getChildNodes();
                for (int i_map = 0; i_map < maps.getLength(); ++i_map) {
                    Node typemap_map_node = maps.item(i_map);
                    if (typemap_map_node.getNodeType() != 1) continue;
                    if (TYPEMAP_MAP_ELEMENT.equalsIgnoreCase(typemap_map_node.getNodeName())) {
                        String db = null;
                        String db_type = null;
                        NamedNodeMap map_attribs = typemap_map_node.getAttributes();
                        for (int i_attr = 0; i_attr < map_attribs.getLength(); ++i_attr) {
                            Node typemap_map_attrib = map_attribs.item(i_attr);
                            typemap_attrib_name = typemap_map_attrib.getNodeName();
                            typemap_attrib_value = typemap_map_attrib.getNodeValue();
                            if (DB_ATTRIBUTE.equalsIgnoreCase(typemap_attrib_name)) {
                                db = typemap_attrib_value;
                                continue;
                            }
                            if (TYPE_ATTRIBUTE.equalsIgnoreCase(typemap_attrib_name)) {
                                db_type = typemap_attrib_value;
                                continue;
                            }
                            throw new SAXException(MSG.getMsg("TypeMap.invald-type-map-attrib", new Object[]{this.m_genericTypeName, typemap_attrib_name, typemap_attrib_value}));
                        }
                        this.m_databaseTypeMap.put(db, db_type);
                        continue;
                    }
                    throw new SAXException(MSG.getMsg("TypeMap.invald-type-map-child", new Object[]{typemap_map_node.getNodeName(), TYPEMAP_MAP_ELEMENT}));
                }
            }
        } else {
            throw new SAXException(MSG.getMsg("TypeMap.node-not-valid-typemap-node", new Object[]{typemap_node}));
        }
        if (this.m_genericTypeName == null) {
            throw new SAXException(MSG.getMsg("TypeMap.missing-type-map-generic-type", new Object[]{TYPE_ATTRIBUTE}));
        }
    }

    public String getMappedType(String generic_type, DatabaseType database) {
        String db_specific_type = null;
        if (this.m_genericTypeName.equalsIgnoreCase(generic_type)) {
            if (database == null) {
                db_specific_type = this.m_databaseTypeMap.get(JAVA_DATABASE_TYPE);
            } else {
                db_specific_type = this.m_databaseTypeMap.get(database.getName());
                if (db_specific_type == null) {
                    db_specific_type = this.m_databaseTypeMap.get(database.getVendor());
                }
            }
        }
        return db_specific_type;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.m_genericTypeName);
        str.append('=');
        str.append(this.m_databaseTypeMap);
        return str.toString();
    }

    public static String getMappedType(Collection<TypeMap> typemaps, String generic_type, DatabaseType database) {
        for (TypeMap typemap : typemaps) {
            String type_name = typemap.getMappedType(generic_type, database);
            if (type_name == null) continue;
            return type_name;
        }
        return null;
    }

    private static boolean isTypeMap(Node node_to_test) {
        String node_name = node_to_test.getNodeName();
        return TYPEMAP_ELEMENT.equalsIgnoreCase(node_name);
    }

    private static Collection<TypeMap> readTypeMaps(Node typemaps_node) throws SAXException {
        ArrayList<TypeMap> result = new ArrayList<TypeMap>();
        NodeList typemap_nodes = typemaps_node.getChildNodes();
        for (int j = 0; j < typemap_nodes.getLength(); ++j) {
            try {
                Node node = typemap_nodes.item(j);
                if (node.getNodeType() != 1) continue;
                result.add(new TypeMap(node));
                continue;
            }
            catch (SAXException e) {
                throw new SAXException(MSG.getMsg("TypeMap.invalid-type-map", new Object[]{e}));
            }
        }
        return result;
    }

    public static Collection<TypeMap> loadKnownTypeMaps() {
        if (m_knownTypes == null) {
            InputStream stream = TypeMap.class.getClassLoader().getResourceAsStream(DB_TYPEMAPS_XML_FILENAME);
            if (stream == null) {
                throw new IllegalStateException(MSG.getMsg("TypeMap.known-typemaps-xml-file-not-found", new Object[]{DB_TYPEMAPS_XML_FILENAME}));
            }
            try {
                m_knownTypes = TypeMap.loadTypeMapsFromStream(stream);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return m_knownTypes;
    }

    public static Collection<TypeMap> loadTypeMapsFromStream(InputStream xml_stream) throws Exception {
        if (xml_stream == null) {
            throw new NullPointerException("xml_stream == null");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xml_stream);
        Collection<TypeMap> typemaps = TypeMap.readTypeMaps(doc.getDocumentElement());
        LOG.debug("TypeMap.loaded-typemaps", new Object[]{typemaps});
        return typemaps;
    }
}

