/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbsetup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbsetup.BaseFileSetTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSetupCombiner
extends BaseFileSetTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private File m_destFile = null;
    private String m_order = null;
    private String m_name = null;
    private ArrayList<Environment.Variable> sysProps = new ArrayList();

    public void setDestfile(File destFile) {
        this.m_destFile = destFile;
    }

    public void setOrder(String order) {
        this.m_order = order;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void addSysproperty(Environment.Variable sysprop) {
        this.sysProps.add(sysprop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        this.validateAttributes();
        Properties old_sysprops = new Properties();
        ArrayList<String> nonexistent_sysprops = new ArrayList<String>();
        for (Environment.Variable variable : this.sysProps) {
            String old_value = System.setProperty(variable.getKey(), variable.getValue());
            if (old_value == null) {
                nonexistent_sysprops.add(variable.getKey());
                continue;
            }
            old_sysprops.put(variable.getKey(), old_value);
        }
        try {
            PrintWriter printWriter2;
            PrintWriter printWriter = null;
            List<File> files_to_combine = this.getAllFiles();
            if (this.m_order != null) {
                ArrayList<String> order_list = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(this.m_order, ", \n\r\t");
                while (tok.hasMoreTokens()) {
                    order_list.add(tok.nextToken());
                }
                Collections.sort(files_to_combine, new OrderComparator(order_list));
            }
            try {
                printWriter2 = new PrintWriter(new FileWriter(this.m_destFile));
                this.writePrefix(printWriter2);
                this.catFiles(files_to_combine, printWriter2);
                this.writeSuffix(printWriter2);
                if (printWriter2 == null) return;
            }
            catch (IOException ioe) {
                try {
                    throw new BuildException((Throwable)ioe);
                }
                catch (Throwable throwable) {
                    if (printWriter == null) throw throwable;
                    try {
                        printWriter.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                printWriter2.close();
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        finally {
            for (String string : nonexistent_sysprops) {
                System.clearProperty(string);
            }
            Iterator<Object> i$ = old_sysprops.entrySet().iterator();
            while (true) {
                if (!i$.hasNext()) {
                }
                Map.Entry entry = (Map.Entry)i$.next();
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void catFiles(List<File> files, PrintWriter pw) throws IOException {
        BufferedReader in = null;
        try {
            for (int i = 0; i < files.size(); ++i) {
                String line;
                File current_file = files.get(i);
                String current_filename = current_file.getName();
                in = new BufferedReader(new InputStreamReader(new FileInputStream(current_file)));
                pw.println("<!-- BEGIN: " + current_filename + " -->");
                while ((line = in.readLine()) != null) {
                    String trimmed_line = line.trim();
                    if (trimmed_line.startsWith("<?") || trimmed_line.startsWith("</dbsetup>")) continue;
                    if (trimmed_line.startsWith("<dbsetup")) {
                        while (trimmed_line.indexOf(">") == -1 && (trimmed_line = in.readLine()) != null) {
                        }
                        continue;
                    }
                    pw.println(line);
                }
                in.close();
                in = null;
                pw.println("<!-- END: " + current_filename + " -->");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    protected void validateAttributes() throws BuildException {
        super.validateAttributes();
        if (this.m_destFile == null) {
            throw new BuildException(MSG.getMsg("Task.missing-attrib", new Object[]{this.getTaskName(), "destFile"}));
        }
        if (this.m_name == null) {
            throw new BuildException(MSG.getMsg("Task.missing-attrib", new Object[]{this.getTaskName(), "name"}));
        }
    }

    private void writePrefix(PrintWriter pw) throws IOException {
        pw.println(XML_PREFIX);
        pw.println("<dbsetup name=\"" + this.m_name + "\">");
    }

    private void writeSuffix(PrintWriter pw) throws IOException {
        pw.println("</dbsetup>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OrderComparator
    implements Comparator {
        private List<String> orderList;

        public OrderComparator(List<String> order) {
            this.orderList = order;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof File && o2 instanceof File) {
                String f1 = ((File)o1).getName();
                String f2 = ((File)o2).getName();
                int idx1 = this.findIndex(f1);
                int idx2 = this.findIndex(f2);
                if (idx1 == -1 && idx2 != -1) {
                    return Integer.MAX_VALUE;
                }
                if (idx2 == -1 && idx1 != -1) {
                    return Integer.MIN_VALUE;
                }
                return idx1 - idx2;
            }
            return 0;
        }

        private int findIndex(String fname) {
            int indexOfLongestMatch = -1;
            int lengthOfLongestMatch = 0;
            for (int i = 0; i < this.orderList.size(); ++i) {
                String possibleMatch = this.orderList.get(i);
                int possibleMatchLen = possibleMatch.length();
                if (!fname.startsWith(possibleMatch) || possibleMatchLen <= lengthOfLongestMatch) continue;
                indexOfLongestMatch = i;
                lengthOfLongestMatch = possibleMatchLen;
            }
            return indexOfLongestMatch;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof OrderComparator) {
                OrderComparator oc = (OrderComparator)o;
                return this.orderList == null && oc.orderList == null || ((Object)this.orderList).equals(oc.orderList);
            }
            return false;
        }
    }
}

