/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;

public class SST_CreateSequence
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String m_name = null;
    private String m_initial = "1";
    private String m_increment = "1";

    public void setName(String name) {
        this.m_name = name;
    }

    public void setIncrement(String increment) {
        this.m_increment = increment;
    }

    public void setInitial(String initial) {
        this.m_initial = initial;
    }

    public void execute() throws BuildException {
        if (!this.isDBTargeted()) {
            return;
        }
        this.validateAttributes();
        try {
            DatabaseType db_type = this.getDatabaseType();
            Connection conn = this.getConnection();
            this.log(MSG.getMsg("SchemaSpecTask.createsequence.executing", new Object[]{this.m_name, this.m_initial, this.m_increment}));
            db_type.createSequence(conn, this.m_name, this.m_initial, this.m_increment);
        }
        catch (Exception e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.failure", new Object[]{"CreateSequence", e}), (Throwable)e);
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.m_name == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"CreateSequence", "name"}));
        }
        if (this.m_increment == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"CreateSequence", "increment"}));
        }
        if (this.m_initial == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"CreateSequence", "initial"}));
        }
        try {
            Integer.parseInt(this.m_increment);
        }
        catch (NumberFormatException e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.invalid-attrib", new Object[]{"CreateSequence", "increment", this.m_increment}));
        }
        try {
            Integer.parseInt(this.m_initial);
        }
        catch (NumberFormatException e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.invalid-attrib", new Object[]{"CreateSequence", "initial", this.m_initial}));
        }
    }
}

