/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.rhq.core.db.setup.Column;
import org.rhq.core.db.setup.Data;
import org.rhq.core.db.setup.DataSet;
import org.rhq.core.db.setup.Table;

class SqlDataSet
extends DataSet {
    private final ResultSet m_resRows;
    private final Table m_table;

    protected SqlDataSet(Table table) throws SQLException {
        super(table.getName(), table.getDBSetup());
        this.m_table = table;
        String strCmd = table.getQueryCommand();
        this.m_resRows = table.getDBSetup().getConnection().createStatement().executeQuery(strCmd);
    }

    protected Data getData(int columnIndex) {
        Data dataResult = null;
        try {
            Column col = (Column)this.m_table.getColumns().get(columnIndex);
            dataResult = new Data(col.getName(), this.m_resRows.getString(columnIndex + 1));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dataResult;
    }

    protected boolean next() {
        boolean bResult;
        try {
            bResult = this.m_resRows.next();
        }
        catch (SQLException e) {
            bResult = false;
        }
        return bResult;
    }
}

