/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeTypeHashSet;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MimeUtilMimeDetectorRegistry {
    private static Log log = LogFactory.getLog((Class)MimeUtilMimeDetectorRegistry.class);
    private Map mimeDetectors = new TreeMap();

    MimeUtilMimeDetectorRegistry() {
    }

    MimeDetector addMimeDetector(MimeDetector mimeDetector) {
        if (this.mimeDetectors.containsKey(mimeDetector.getName())) {
            log.error((Object)("MimeDetector [" + mimeDetector.getName() + "] will not be registered as a MimeDetector with this name is already registered."));
            return (MimeDetector)this.mimeDetectors.get(mimeDetector.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering MimeDetect with name [" + mimeDetector.getName() + "] and description [" + mimeDetector.getDescription() + "]"));
        }
        return this.mimeDetectors.put(mimeDetector.getName(), mimeDetector);
    }

    MimeDetector getMimeDetector(String name) {
        return (MimeDetector)this.mimeDetectors.get(name);
    }

    Collection getMimeTypes(byte[] data, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        if (data != null) {
            Iterator it = this.mimeDetectors.values().iterator();
            while (it.hasNext()) {
                try {
                    MimeDetector md = (MimeDetector)it.next();
                    mimeTypes.addAll(md.getMimeTypes(data));
                }
                catch (UnsupportedOperationException usoe) {
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved mime types [" + ((Object)mimeTypes).toString() + "]"));
        }
        return mimeTypes;
    }

    Collection getMimeTypes(File file, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        Iterator it = this.mimeDetectors.values().iterator();
        while (it.hasNext()) {
            try {
                MimeDetector md = (MimeDetector)it.next();
                mimeTypes.addAll(md.getMimeTypes(file));
            }
            catch (UnsupportedOperationException usoe) {
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved mime types [" + ((Object)mimeTypes).toString() + "]"));
        }
        return mimeTypes;
    }

    Collection getMimeTypes(InputStream in, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        Iterator it = this.mimeDetectors.values().iterator();
        while (it.hasNext()) {
            try {
                MimeDetector md = (MimeDetector)it.next();
                mimeTypes.addAll(md.getMimeTypes(in));
            }
            catch (UnsupportedOperationException usoe) {
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved mime types [" + ((Object)mimeTypes).toString() + "]"));
        }
        return mimeTypes;
    }

    Collection getMimeTypes(String fileName, MimeType unknownMimeType) throws MimeException {
        MimeTypeHashSet mimeTypes = new MimeTypeHashSet();
        Iterator it = this.mimeDetectors.values().iterator();
        while (it.hasNext()) {
            try {
                MimeDetector md = (MimeDetector)it.next();
                mimeTypes.addAll(md.getMimeTypes(fileName));
            }
            catch (UnsupportedOperationException usoe) {
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add(unknownMimeType);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieved mime types [" + ((Object)mimeTypes).toString() + "]"));
        }
        return mimeTypes;
    }

    MimeDetector removeMimeDetector(MimeDetector mimeDetector) {
        if (mimeDetector == null) {
            log.error((Object)"Cannot remove NULL from MimeDetector registry.");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing MimeDetector [" + mimeDetector.getName() + "] from registry."));
        }
        return (MimeDetector)this.mimeDetectors.remove(mimeDetector.getName());
    }
}

