/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.InvalidMagicMimeEntryException;
import eu.medsea.mimeutil.detector.MagicMimeEntry;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MagicMimeMimeDetector
extends MimeDetector {
    private static Log log = LogFactory.getLog((Class)MagicMimeMimeDetector.class);
    private static String[] defaultLocations = new String[]{"/usr/share/mimelnk/magic", "/usr/share/file/magic.mime", "/etc/magic.mime"};
    private static List magicMimeFileLocations = Arrays.asList(defaultLocations);
    private static ArrayList mMagicMimeEntries = new ArrayList();

    public String getDescription() {
        return "Get the mime types of files or streams using the Unix file(5) magic.mime files";
    }

    public Collection getMimeTypesByteArray(byte[] data) throws MimeException {
        HashSet<MimeType> mimeTypes = new HashSet<MimeType>();
        int len = mMagicMimeEntries.size();
        try {
            for (int i = 0; i < len; ++i) {
                MagicMimeEntry me = (MagicMimeEntry)mMagicMimeEntries.get(i);
                MagicMimeEntry matchingMagicMimeEntry = me.getMatch(data);
                if (matchingMagicMimeEntry == null) continue;
                mimeTypes.add(matchingMagicMimeEntry.getMimeType());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return mimeTypes;
    }

    public Collection getMimeTypesInputStream(InputStream in) throws MimeException {
        HashSet<MimeType> mimeTypes = new HashSet<MimeType>();
        int len = mMagicMimeEntries.size();
        try {
            for (int i = 0; i < len; ++i) {
                MagicMimeEntry me = (MagicMimeEntry)mMagicMimeEntries.get(i);
                MagicMimeEntry matchingMagicMimeEntry = me.getMatch(in);
                if (matchingMagicMimeEntry == null) continue;
                mimeTypes.add(matchingMagicMimeEntry.getMimeType());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return mimeTypes;
    }

    public Collection getMimeTypesFile(File file) throws MimeException {
        HashSet<MimeType> mimeTypes = new HashSet<MimeType>();
        if (!file.exists()) {
            return mimeTypes;
        }
        if (file.isDirectory()) {
            mimeTypes.add(MimeUtil.DIRECTORY_MIME_TYPE);
            return mimeTypes;
        }
        int len = mMagicMimeEntries.size();
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            for (int i = 0; i < len; ++i) {
                MagicMimeEntry me = (MagicMimeEntry)mMagicMimeEntries.get(i);
                MagicMimeEntry matchingMagicMimeEntry = me.getMatch(raf);
                if (matchingMagicMimeEntry == null) continue;
                mimeTypes.add(matchingMagicMimeEntry.getMimeType());
            }
        }
        catch (Exception e) {
            throw new MimeException("Error parsing file [" + file.getAbsolutePath() + "]", e);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception e) {
                    log.error((Object)"Error closing file.", (Throwable)e);
                }
            }
        }
        return mimeTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMagicRules() {
        InputStream is;
        block64: {
            block62: {
                block58: {
                    is = null;
                    try {
                        String fname = System.getProperty("magic-mime");
                        if (fname == null || fname.length() == 0) break block58;
                        is = new FileInputStream(fname);
                        try {
                            if (is != null) {
                                MagicMimeMimeDetector.parse("-Dmagic-mime=" + fname, new InputStreamReader(is));
                            }
                        }
                        finally {
                            if (is != null) {
                                block59: {
                                    try {
                                        is.close();
                                    }
                                    catch (Exception e) {
                                        if (!log.isDebugEnabled()) break block59;
                                        log.debug((Object)e.getMessage(), (Throwable)e);
                                    }
                                }
                                is = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to parse custom magic mime file defined by system property -Dmagic-mime [" + System.getProperty("magic-mime") + "]. File will be ignored."), (Throwable)e);
                    }
                }
                try {
                    is = MimeUtil.class.getClassLoader().getResourceAsStream("magic.mime");
                    try {
                        if (is != null) {
                            MagicMimeMimeDetector.parse("classpath:magic-mime", new InputStreamReader(is));
                        }
                    }
                    finally {
                        if (is != null) {
                            block61: {
                                try {
                                    is.close();
                                }
                                catch (Exception e) {
                                    if (!log.isDebugEnabled()) break block61;
                                    log.debug((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            is = null;
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Failed to parse magic.mime rule file on the classpath. File will be ignored.", (Throwable)e);
                }
                try {
                    File f = new File(System.getProperty("user.home") + File.separator + ".magic.mime");
                    if (!f.exists()) break block62;
                    is = new FileInputStream(f);
                    try {
                        if (is != null) {
                            MagicMimeMimeDetector.parse(f.getAbsolutePath(), new InputStreamReader(is));
                        }
                    }
                    finally {
                        if (is != null) {
                            block63: {
                                try {
                                    is.close();
                                }
                                catch (Exception e) {
                                    if (!log.isDebugEnabled()) break block63;
                                    log.debug((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            is = null;
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Failed to parse .magic.mime file from the users home directory. File will be ignored.", (Throwable)e);
                }
            }
            try {
                File f;
                String name = System.getProperty("MAGIC");
                if (name == null || name.length() == 0 || !(f = new File(name = name.indexOf(46) < 0 ? name + ".mime" : name.substring(0, name.indexOf(46) - 1) + "mime")).exists()) break block64;
                is = new FileInputStream(f);
                try {
                    if (is != null) {
                        MagicMimeMimeDetector.parse(f.getAbsolutePath(), new InputStreamReader(is));
                    }
                }
                finally {
                    if (is != null) {
                        block65: {
                            try {
                                is.close();
                            }
                            catch (Exception e) {
                                if (!log.isDebugEnabled()) break block65;
                                log.debug((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        is = null;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to parse magic.mime file from directory located by environment variable MAGIC. File will be ignored.", (Throwable)e);
            }
        }
        int mMagicMimeEntriesSizeBeforeReadingOS = mMagicMimeEntries.size();
        Iterator it = magicMimeFileLocations.iterator();
        while (it.hasNext()) {
            MagicMimeMimeDetector.parseMagicMimeFileLocation((String)it.next());
        }
        if (mMagicMimeEntriesSizeBeforeReadingOS == mMagicMimeEntries.size()) {
            try {
                String resource = "eu/medsea/mimeutil/magic.mime";
                is = MimeUtil.class.getClassLoader().getResourceAsStream(resource);
                MagicMimeMimeDetector.parse("resource:" + resource, new InputStreamReader(is));
            }
            catch (Exception e) {
                log.error((Object)"Failed to process internal magic.mime file.", (Throwable)e);
            }
            finally {
                if (is != null) {
                    block67: {
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block67;
                            log.debug((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    is = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseMagicMimeFileLocation(String location) {
        FileInputStream is = null;
        List magicMimeFiles = MagicMimeMimeDetector.getMagicFilesFromMagicMimeFileLocation(location);
        Iterator itFile = magicMimeFiles.iterator();
        while (itFile.hasNext()) {
            File f = (File)itFile.next();
            try {
                is = new FileInputStream(f);
                if (!f.exists()) continue;
                MagicMimeMimeDetector.parse(f.getAbsolutePath(), new InputStreamReader(is));
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
            finally {
                block12: {
                    if (is == null) continue;
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
                is = null;
            }
        }
    }

    private static List getMagicFilesFromMagicMimeFileLocation(String magicMimeFileLocation) {
        LinkedList<File> magicMimeFiles = new LinkedList<File>();
        if (magicMimeFileLocation.indexOf(42) < 0) {
            magicMimeFiles.add(new File(magicMimeFileLocation));
        } else {
            String fileNameSimplePattern;
            File dir;
            int lastSlashPos = magicMimeFileLocation.lastIndexOf(47);
            if (lastSlashPos < 0) {
                dir = new File("someProbablyNotExistingFile").getAbsoluteFile().getParentFile();
                fileNameSimplePattern = magicMimeFileLocation;
            } else {
                String dirName = magicMimeFileLocation.substring(0, lastSlashPos);
                if (dirName.indexOf(42) >= 0) {
                    throw new UnsupportedOperationException("The wildcard '*' is not allowed in directory part of the location! Do you want to implement expressions like /path/**/*.mime for recursive search? Please do!");
                }
                dir = new File(dirName);
                fileNameSimplePattern = magicMimeFileLocation.substring(lastSlashPos + 1);
            }
            if (!dir.isDirectory()) {
                return Collections.EMPTY_LIST;
            }
            String s = fileNameSimplePattern.replaceAll("\\.", "\\\\.");
            s = s.replaceAll("\\*", ".*");
            Pattern fileNamePattern = Pattern.compile(s);
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!fileNamePattern.matcher(file.getName()).matches()) continue;
                magicMimeFiles.add(file);
            }
        }
        return magicMimeFiles;
    }

    private static void parse(String magicFile, Reader r) throws IOException {
        long start = System.currentTimeMillis();
        BufferedReader br = new BufferedReader(r);
        ArrayList<String> sequence = new ArrayList<String>();
        long lineNumber = 0L;
        String line = br.readLine();
        if (line != null) {
            ++lineNumber;
        }
        block0: while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = br.readLine();
                if (line == null) continue;
                ++lineNumber;
                continue;
            }
            sequence.add(line);
            while (true) {
                if ((line = br.readLine()) != null) {
                    ++lineNumber;
                }
                if (line == null) {
                    MagicMimeMimeDetector.addEntry(magicFile, lineNumber, sequence);
                    sequence.clear();
                    continue block0;
                }
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (line.charAt(0) != '>') {
                    MagicMimeMimeDetector.addEntry(magicFile, lineNumber, sequence);
                    sequence.clear();
                    continue block0;
                }
                sequence.add(line);
            }
        }
        if (!sequence.isEmpty()) {
            MagicMimeMimeDetector.addEntry(magicFile, lineNumber, sequence);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing \"" + magicFile + "\" took " + (System.currentTimeMillis() - start) + " msec."));
        }
    }

    private static void addEntry(String magicFile, long lineNumber, ArrayList aStringArray) {
        try {
            MagicMimeEntry magicEntry = new MagicMimeEntry(aStringArray);
            mMagicMimeEntries.add(magicEntry);
            if (magicEntry.getMimeType() != null) {
                MimeUtil.addKnownMimeType(magicEntry.getMimeType());
            }
        }
        catch (InvalidMagicMimeEntryException e) {
            log.warn((Object)(e.getClass().getName() + ": " + e.getMessage() + ": file \"" + magicFile + "\": before or at line " + lineNumber), (Throwable)e);
        }
    }

    static {
        MagicMimeMimeDetector.initMagicRules();
        MimeUtil.addMimeDetector(new MagicMimeMimeDetector());
    }
}

