/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee.serviceref;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.ServiceRefMetaDataParserFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefElement;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedPortComponentRefMetaData
extends ServiceRefElement {
    private UnifiedServiceRefMetaData serviceRefMetaData;
    private String serviceEndpointInterface;
    private Boolean enableMTOM = Boolean.FALSE;
    private String portComponentLink;
    private QName portQName;
    private List<UnifiedCallPropertyMetaData> callProperties = new ArrayList<UnifiedCallPropertyMetaData>();
    private List<UnifiedStubPropertyMetaData> stubProperties = new ArrayList<UnifiedStubPropertyMetaData>();
    private String configName;
    private String configFile;

    public UnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData serviceRefMetaData) {
        this.serviceRefMetaData = serviceRefMetaData;
    }

    public void merge(UnifiedPortComponentRefMetaData pcref) {
        this.portQName = pcref.portQName;
        this.configName = pcref.configName;
        this.configFile = pcref.configFile;
        this.callProperties = pcref.callProperties;
        this.stubProperties = pcref.stubProperties;
    }

    public UnifiedServiceRefMetaData getServiceRefMetaData() {
        return this.serviceRefMetaData;
    }

    public Boolean getEnableMTOM() {
        return this.enableMTOM;
    }

    public void setEnableMTOM(Boolean enableMTOM) {
        this.enableMTOM = enableMTOM;
    }

    public String getPortComponentLink() {
        return this.portComponentLink;
    }

    public void setPortComponentLink(String portComponentLink) {
        this.portComponentLink = portComponentLink;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setServiceEndpointInterface(String serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public void setPortQName(QName portQName) {
        this.portQName = portQName;
    }

    public List<UnifiedCallPropertyMetaData> getCallProperties() {
        return this.callProperties;
    }

    public void setCallProperties(List<UnifiedCallPropertyMetaData> callProps) {
        this.callProperties = callProps;
    }

    public void addCallProperty(UnifiedCallPropertyMetaData callProp) {
        this.callProperties.add(callProp);
    }

    public List<UnifiedStubPropertyMetaData> getStubProperties() {
        return this.stubProperties;
    }

    public void setStubProperties(List<UnifiedStubPropertyMetaData> stubProps) {
        this.stubProperties = stubProps;
    }

    public void addStubProperty(UnifiedStubPropertyMetaData stubProp) {
        this.stubProperties.add(stubProp);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void importStandardXml(Element root) {
        SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
        ServiceRefMetaDataParserFactory factory = provider.getSPI(ServiceRefMetaDataParserFactory.class);
        factory.getServiceRefMetaDataParser().importStandardXml(root, this);
    }

    public void importJBossXml(Element root) {
        SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
        ServiceRefMetaDataParserFactory factory = provider.getSPI(ServiceRefMetaDataParserFactory.class);
        factory.getServiceRefMetaDataParser().importJBossXml(root, this);
    }

    public boolean matches(String seiName, QName portName) {
        if (seiName == null && portName == null) {
            throw new IllegalArgumentException("Cannot match against seiName=null && portName=null.");
        }
        boolean match = false;
        if (portName != null) {
            match = portName.equals(this.getPortQName());
        }
        if (!match) {
            match = seiName.equals(this.getServiceEndpointInterface());
        }
        return match;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nUnifiedPortComponentRef");
        str.append("\n serviceEndpointInterface=" + this.serviceEndpointInterface);
        str.append("\n portQName=" + this.portQName);
        str.append("\n enableMTOM=" + this.enableMTOM);
        str.append("\n portComponentLink=" + this.portComponentLink);
        str.append("\n callProperties=" + this.callProperties);
        str.append("\n stubProperties=" + this.stubProperties);
        str.append("\n configName=" + this.configName);
        str.append("\n configFile=" + this.configFile);
        return str.toString();
    }
}

