/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.Dest;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyHandler
extends ExistingEntityHandler {
    private Logger log = LoggerFactory.getLogger(CopyHandler.class);

    public CopyHandler(HttpManager manager) {
        super(manager);
    }

    protected Request.Method method() {
        return Request.Method.COPY;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof CopyableResource;
    }

    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        CopyableResource r = (CopyableResource)resource;
        String sDest = request.getDestinationHeader();
        sDest = HttpManager.decodeUrl(sDest);
        Dest dest = new Dest(request.getHostHeader(), sDest);
        Resource rDest = this.manager.getResourceFactory().getResource(dest.host, dest.url);
        this.log.debug("process: copying from: " + r.getName() + " -> " + dest.url + "/" + dest.name);
        if (rDest == null) {
            this.log.debug("process: destination parent does not exist: " + sDest);
            this.manager.getResponseHandler().respondConflict(resource, response, request, "Destination does not exist: " + sDest);
        } else if (!(rDest instanceof CollectionResource)) {
            this.log.debug("process: destination exists but is not a collection");
            this.manager.getResponseHandler().respondConflict(resource, response, request, "Destination exists but is not a collection: " + sDest);
        } else {
            this.log.debug("process: moving resource to: " + rDest.getName());
            r.copyTo((CollectionResource)rDest, dest.name);
            this.manager.getResponseHandler().respondCreated(resource, response, request);
        }
        this.log.debug("process: finished");
    }
}

