/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExistingEntityHandler
extends Handler {
    private Logger log = LoggerFactory.getLogger(ExistingEntityHandler.class);

    public ExistingEntityHandler(HttpManager manager) {
        super(manager);
    }

    protected abstract void process(HttpManager var1, Request var2, Response var3, Resource var4) throws NotAuthorizedException, ConflictException;

    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException {
        String host = request.getHostHeader();
        String url = HttpManager.decodeUrl(request.getAbsolutePath());
        this.log.debug("find resource: " + url);
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            this.processResource(manager, request, response, r);
        } else {
            this.respondNotFound(response, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, ConflictException {
        long t = System.currentTimeMillis();
        try {
            manager.onProcessResourceStart(request, response, resource);
            if (this.doCheckRedirect(request, response, resource)) {
                return;
            }
            if (!this.isCompatible(resource)) {
                this.respondMethodNotImplemented(resource, response, request);
                return;
            }
            if (!this.checkAuthorisation(resource, request)) {
                this.respondUnauthorised(resource, response, request);
                return;
            }
            this.process(manager, request, response, resource);
        }
        finally {
            t = System.currentTimeMillis() - t;
            manager.onProcessResourceFinish(request, response, resource, t);
        }
    }

    protected boolean doCheckRedirect(Request request, Response response, Resource resource) {
        return false;
    }
}

