/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ResponseHandler;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Handler {
    private static final Logger log = LoggerFactory.getLogger(Handler.class);
    public static final String METHOD_NOT_ALLOWED_HTML = "<html><body><h1>Method Not Allowed</h1></body></html>";
    public static final String NOT_FOUND_HTML = "<html><body><h1>Not Found (404)</h1></body></html>";
    public static final String METHOD_NOT_IMPLEMENTED_HTML = "<html><body><h1>Method Not Implemented</h1></body></html>";
    public static final String CONFLICT_HTML = "<html><body><h1>Conflict</h1></body></html>";
    protected final HttpManager manager;

    public abstract void process(HttpManager var1, Request var2, Response var3) throws ConflictException, NotAuthorizedException;

    protected abstract boolean isCompatible(Resource var1);

    abstract Request.Method method();

    public Handler(HttpManager manager) {
        this.manager = manager;
    }

    protected ResponseHandler getResponseHandler() {
        return this.manager.getResponseHandler();
    }

    protected boolean checkAuthorisation(Resource handler, Request request) {
        Auth auth = request.getAuthorization();
        if (auth != null) {
            Object authTag = handler.authenticate(auth.user, auth.password);
            if (authTag == null) {
                log.warn("failed to authenticate");
                auth = null;
            } else {
                auth.setTag(authTag);
            }
        } else {
            auth = this.manager.getSessionAuthentication(request);
        }
        boolean authorised = handler.authorise(request, request.getMethod(), auth);
        if (!authorised) {
            log.warn("Not authorised, requesting basic authentication");
            return false;
        }
        return true;
    }

    protected void respondUnauthorised(Resource resource, Response response, Request request) {
        this.manager.getResponseHandler().respondUnauthorised(resource, response, request);
    }

    protected void respondMethodNotImplemented(Resource resource, Response response, Request request) {
        this.manager.getResponseHandler().respondMethodNotImplemented(resource, response, request);
    }

    protected void respondMethodNotAllowed(Resource res, Response response, Request request) {
        this.manager.getResponseHandler().respondMethodNotAllowed(res, response, request);
    }

    protected void respondConflict(Resource resource, Response response, Request request) {
        this.manager.getResponseHandler().respondConflict(resource, response, request, null);
    }

    protected void respondRedirect(Response response, Request request, String redirectUrl) {
        this.manager.getResponseHandler().respondRedirect(response, request, redirectUrl);
    }

    protected void respondNotFound(Response response, Request request) {
        this.getResponseHandler().respondNotFound(response, request);
    }

    protected void output(Response response, String s) {
        PrintWriter pw = new PrintWriter(response.getOutputStream(), true);
        pw.print(s);
        pw.flush();
    }
}

