/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.LockInfoSaxHandler;
import com.bradmcevoy.http.Request;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class LockInfo {
    private static Logger log = LoggerFactory.getLogger(LockInfo.class);
    public LockScope scope;
    public LockType type;
    public String owner;
    public LockDepth depth;

    public static LockInfo parseLockInfo(Request request) throws IOException, FileNotFoundException, SAXException {
        InputStream in = request.getInputStream();
        XMLReader reader = XMLReaderFactory.createXMLReader();
        LockInfoSaxHandler handler = new LockInfoSaxHandler();
        reader.setContentHandler(handler);
        reader.parse(new InputSource(in));
        LockInfo info = handler.getInfo();
        info.depth = LockDepth.INFINITY;
        log.debug("parsed lock info: " + info);
        return info;
    }

    public LockInfo(LockScope scope, LockType type, String owner, LockDepth depth) {
        this.scope = scope;
        this.type = type;
        this.owner = owner;
        this.depth = depth;
    }

    public LockInfo() {
    }

    public String toString() {
        return "scope: " + this.scope.name() + ", type: " + this.type.name() + ", owner: " + this.owner + ", depth:" + (Object)((Object)this.depth);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockDepth {
        ZERO,
        INFINITY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockType {
        READ,
        WRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockScope {
        NONE,
        SHARED,
        EXCLUSIVE;

    }
}

