/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.Dest;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveHandler
extends ExistingEntityHandler {
    private Logger log = LoggerFactory.getLogger(MoveHandler.class);

    public MoveHandler(HttpManager manager) {
        super(manager);
    }

    public Request.Method method() {
        return Request.Method.MOVE;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof MoveableResource;
    }

    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        MoveableResource r = (MoveableResource)resource;
        String sDest = request.getDestinationHeader();
        this.log.debug("dest header1: " + sDest);
        URI destUri = URI.create(sDest);
        sDest = destUri.getPath();
        this.log.debug("dest header2: " + sDest);
        Dest dest = new Dest(destUri.getHost(), sDest);
        this.log.debug("looking for destination parent: " + dest.host + " - " + dest.url);
        Resource rDest = this.manager.getResourceFactory().getResource(dest.host, dest.url);
        this.log.debug("process: moving from: " + r.getName() + " -> " + dest.url + " with name: " + dest.name);
        if (rDest == null) {
            this.log.debug("process: destination parent does not exist: " + sDest);
            this.getResponseHandler().respondConflict(resource, response, request, "Destination parent does not exist: " + sDest);
        } else if (!(rDest instanceof CollectionResource)) {
            this.log.debug("process: destination exists but is not a collection");
            this.getResponseHandler().respondConflict(resource, response, request, "Destination exists but is not a collection: " + sDest);
        } else {
            this.log.debug("process: moving resource to: " + rDest.getName());
            r.moveTo((CollectionResource)rDest, dest.name);
            this.getResponseHandler().respondCreated(resource, response, request);
        }
        this.log.debug("process: finished");
    }
}

