/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NewEntityHandler
extends Handler {
    private Logger log = LoggerFactory.getLogger(NewEntityHandler.class);

    public NewEntityHandler(HttpManager manager) {
        super(manager);
    }

    protected abstract void process(HttpManager var1, Request var2, Response var3, CollectionResource var4, String var5) throws ConflictException, NotAuthorizedException;

    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException {
        String host = request.getHostHeader();
        String url = HttpManager.decodeUrl(request.getAbsolutePath());
        this.log.debug("process request: host: " + host + " url: " + url);
        Path path = Path.path(url);
        String name = path.getName();
        path = path.getParent();
        url = path.toString();
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            this.log.debug("process: resource: " + r.getClass().getName());
            this.process(request, response, r, name);
        } else {
            response.setStatus(Response.Status.SC_NOT_FOUND);
        }
    }

    protected void process(Request request, Response response, Resource resource, String name) throws ConflictException, NotAuthorizedException {
        if (!this.checkAuthorisation(resource, request)) {
            this.respondUnauthorised(resource, response, request);
            return;
        }
        if (!this.isCompatible(resource)) {
            this.respondMethodNotImplemented(resource, response, request);
            return;
        }
        if (resource instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)resource;
            this.process(this.manager, request, response, col, name);
        } else {
            this.respondConflict(resource, response, request);
        }
    }
}

