/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropFindSaxHandler
extends DefaultHandler {
    private Stack<String> elementPath = new Stack();
    private Map<String, String> attributes = new HashMap<String, String>();
    private StringBuilder sb = new StringBuilder();
    private boolean inProp;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.elementPath.size() > 0 && this.elementPath.peek().endsWith("prop")) {
            this.inProp = true;
        }
        this.elementPath.push(localName);
        super.startElement(uri, localName, name, attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inProp) {
            this.sb.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.elementPath.pop();
        if (this.elementPath.size() > 0 && this.elementPath.peek().endsWith("prop")) {
            if (this.sb != null) {
                this.getAttributes().put(localName, this.sb.toString().trim());
            }
            this.sb.delete(0, this.sb.length());
        }
        super.endElement(uri, localName, name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

