/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleResource
implements GetableResource {
    private static final Logger log = LoggerFactory.getLogger(SimpleResource.class);
    final String name;
    final Date modDate;
    final byte[] content;
    final String contentType;
    final String uniqueId;
    final String realm;

    public SimpleResource(String name, Date modDate, byte[] content, String contentType, String uniqueId, String realm) {
        this.name = name;
        this.modDate = modDate;
        this.content = content;
        this.contentType = contentType;
        this.uniqueId = uniqueId;
        this.realm = realm;
    }

    @Override
    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException {
        out.write(this.content);
    }

    @Override
    public Long getMaxAgeSeconds(Auth auth) {
        return 60L;
    }

    @Override
    public String getContentType(String accepts) {
        return this.contentType;
    }

    @Override
    public Long getContentLength() {
        return this.content.length;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object authenticate(String user, String password) {
        return user;
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public Date getModifiedDate() {
        return this.modDate;
    }

    @Override
    public String checkRedirect(Request request) {
        return null;
    }
}

