/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;

public abstract class OracleDatabaseType
extends DatabaseType {
    public static final String VENDOR = "oracle";

    @Override
    public String getVendor() {
        return VENDOR;
    }

    @Override
    public String getBooleanValue(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    public void setBooleanValue(boolean bool, PreparedStatement ps, int idx) throws SQLException {
        ps.setInt(idx, bool ? 1 : 0);
    }

    @Override
    public boolean isTableNotFoundException(SQLException e) {
        return e.getErrorCode() == 942;
    }

    @Override
    public int getSequenceValue(Connection conn, String table, String key) throws SQLException {
        String query = "SELECT " + table + "_" + key + "_seq.currval FROM DUAL";
        PreparedStatement selectPS = null;
        ResultSet rs = null;
        try {
            selectPS = conn.prepareStatement(query);
            rs = selectPS.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            throw new RuntimeException(DbUtilsI18NFactory.getMsg().getMsg("DatabaseTypeFactory.not-a-sequence", new Object[]{query}));
        }
        finally {
            this.closeJDBCObjects(null, selectPS, rs);
        }
    }

    @Override
    public int getNextSequenceValue(Connection conn, String table, String key) throws SQLException {
        String query = "SELECT " + table + "_" + key + "_seq.nextval FROM DUAL";
        PreparedStatement selectPS = null;
        ResultSet rs = null;
        try {
            selectPS = conn.prepareStatement(query);
            rs = selectPS.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            throw new RuntimeException(DbUtilsI18NFactory.getMsg().getMsg("DatabaseTypeFactory.not-a-sequence", new Object[]{query}));
        }
        finally {
            this.closeJDBCObjects(null, selectPS, rs);
        }
    }

    @Override
    public void createSequence(Connection conn, String name, String initial, String increment) throws SQLException {
        String sql = "CREATE SEQUENCE " + name + " START WITH " + initial + " INCREMENT BY " + increment + " NOMAXVALUE NOCYCLE CACHE 10";
        this.executeSql(conn, sql);
    }

    @Override
    public void alterColumn(Connection conn, String table, String column, String generic_column_type, String default_value, String precision, Boolean nullable, Boolean reindex) throws SQLException {
        String sql = "ALTER TABLE " + table + " MODIFY (" + column;
        if (generic_column_type != null) {
            String db_column_type = this.getDBTypeFromGenericType(generic_column_type);
            sql = sql + " " + db_column_type;
        }
        if (default_value != null) {
            sql = sql + " DEFAULT '" + default_value + "'";
        }
        if (precision != null) {
            sql = sql + " (" + precision + ")";
        }
        if (nullable != null) {
            sql = sql + (nullable != false ? " NULL" : " NOT NULL");
        }
        sql = sql + ")";
        this.executeSql(conn, sql);
        if (reindex != null && reindex.booleanValue()) {
            this.reindexTable(conn, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reindexTable(Connection conn, String table) throws SQLException {
        PreparedStatement selectPS = null;
        ResultSet rs = null;
        ArrayList<String> sql_list = new ArrayList<String>();
        try {
            selectPS = conn.prepareStatement("SELECT index_name FROM user_indexes WHERE table_name = '" + table + "' AND index_type = 'NORMAL'");
            rs = selectPS.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString(1);
                sql_list.add("ALTER INDEX " + indexName + " REBUILD");
            }
            this.executeSql(conn, sql_list);
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(selectPS);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closeStatement(selectPS);
    }
}

