/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.TypeMap;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.DBUpgrader;

public abstract class SchemaSpecTask
extends Task {
    private static final Msg MSG;
    private Connection connection = null;
    private DBUpgrader upgrader = null;
    private String targetDBVendor;
    private String targetDBVersion;
    private String ignoreError;
    private static Map<String, Integer> SQL_TYPES;

    public void setTargetDBVendor(String vendor) {
        this.targetDBVendor = vendor;
    }

    public void setTargetDBVersion(String version) {
        this.targetDBVersion = version;
    }

    public String getTargetDBVendor() {
        return this.targetDBVendor;
    }

    public String getTargetDBVersion() {
        return this.targetDBVersion;
    }

    public String getIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(String ignoreError) {
        this.ignoreError = ignoreError;
    }

    public boolean isIgnoreError() {
        return new Boolean(this.ignoreError);
    }

    public boolean isDBTargeted() {
        if (this.targetDBVersion != null && this.targetDBVendor == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.invalid-target-db", new Object[]{this.getTaskName(), this.targetDBVersion}));
        }
        if (this.targetDBVendor != null) {
            DatabaseType db_type = this.getDatabaseType();
            if (!this.targetDBVendor.equalsIgnoreCase(db_type.getVendor())) {
                this.log(MSG.getMsg("SchemaSpecTask.vendor-mismatch", new Object[]{this.targetDBVendor, db_type.getVendor()}));
                return false;
            }
            if (this.targetDBVersion != null && !this.targetDBVersion.equalsIgnoreCase(db_type.getVersion())) {
                this.log(MSG.getMsg("SchemaSpecTask.version-mismatch", new Object[]{this.targetDBVendor, this.targetDBVersion, db_type.getVersion()}));
                return false;
            }
        }
        return true;
    }

    public void initialize(Connection db_conn, DBUpgrader db_upgrader) {
        this.connection = db_conn;
        this.upgrader = db_upgrader;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Connection getNewConnection() throws SQLException {
        return this.upgrader.getConnection();
    }

    public DatabaseType getDatabaseType() {
        return this.upgrader.getDatabaseType();
    }

    public int translateSqlType(String generic_type_name) throws BuildException {
        String mapped_type = TypeMap.getMappedType(this.upgrader.getTypeMaps(), generic_type_name, null);
        Integer sql_type = SQL_TYPES.get(mapped_type);
        if (sql_type == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.invalid-jdbc-sql-type", new Object[]{generic_type_name}));
        }
        return sql_type;
    }

    public String getDBSpecificTypeName(String generic_type_name) throws BuildException {
        String mapped_type = TypeMap.getMappedType(TypeMap.loadKnownTypeMaps(), generic_type_name, this.getDatabaseType());
        if (mapped_type == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.no-db-specific-type-mapping", new Object[]{generic_type_name, this.getDatabaseType()}));
        }
        return mapped_type;
    }

    static {
        Field[] fields;
        MSG = DbAntI18NFactory.getMsg();
        SQL_TYPES = new HashMap<String, Integer>();
        for (Field field : fields = Types.class.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods)) continue;
            try {
                SQL_TYPES.put(field.getName(), new Integer(field.getInt(null)));
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae);
            }
        }
    }
}

