/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;

public class ResourceAncestryUpgradeTask
implements DatabaseUpgradeTask {
    public static final String ANCESTRY_ENTRY_DELIM = "_:_";
    public static final String ANCESTRY_DELIM = "_::_";
    private DatabaseType databaseType;
    private Connection connection;

    @Override
    public void execute(DatabaseType databaseType, Connection connection) throws SQLException {
        this.databaseType = databaseType;
        this.connection = connection;
        String sql = "select rt.ID, res.ID, res.NAME from RHQ_RESOURCE res, RHQ_RESOURCE_TYPE rt where        res.RESOURCE_TYPE_ID=rt.ID and rt.CATEGORY='PLATFORM'";
        List<Object[]> rs = databaseType.executeSelectSql(connection, sql);
        for (Object[] result : rs) {
            int rtId = (Integer)result[0];
            int resId = (Integer)result[1];
            String resName = (String)result[2];
            this.handleChildren(rtId, resId, resName, null);
        }
    }

    private void handleChildren(int parentRtId, int parentResId, String parentResName, String parentAncestry) throws SQLException {
        String sql = "select rt.ID, res.ID, res.NAME from RHQ_RESOURCE res, RHQ_RESOURCE_TYPE rt where        res.RESOURCE_TYPE_ID=rt.ID and res.PARENT_RESOURCE_ID=" + parentResId;
        List<Object[]> rs = this.databaseType.executeSelectSql(this.connection, sql);
        for (Object[] result : rs) {
            int rtId = (Integer)result[0];
            int resId = (Integer)result[1];
            String resName = (String)result[2];
            String ancestry = this.getAncestry(parentRtId, parentResId, parentResName, parentAncestry);
            String updateSql = "update RHQ_RESOURCE set ANCESTRY='" + ancestry + "' where ID=" + resId;
            this.databaseType.executeSql(this.connection, updateSql);
            this.handleChildren(rtId, resId, resName, ancestry);
        }
    }

    private String getAncestry(int rtId, int resId, String resName, String parentAncestry) {
        StringBuilder ancestry = new StringBuilder();
        ancestry.append(rtId);
        ancestry.append(ANCESTRY_ENTRY_DELIM);
        ancestry.append(resId);
        ancestry.append(ANCESTRY_ENTRY_DELIM);
        ancestry.append(resName);
        if (null != parentAncestry) {
            ancestry.append(ANCESTRY_DELIM);
            ancestry.append(parentAncestry);
        }
        return ancestry.toString();
    }
}

