/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.augeas.tree.impl;

import java.util.List;
import net.augeas.Augeas;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.node.AugeasNodeReal;
import org.rhq.augeas.tree.AugeasTreeException;
import org.rhq.augeas.tree.impl.AbstractAugeasTree;

public class AugeasTreeReal
extends AbstractAugeasTree {
    public AugeasTreeReal(Augeas ag, AugeasModuleConfig moduleConfig) {
        super(ag, moduleConfig);
    }

    @Override
    public AugeasNode createNode(String fullPath) throws AugeasTreeException {
        AugeasNodeReal node = null;
        int index = fullPath.lastIndexOf(47);
        if (index == -1) {
            throw new AugeasTreeException("Node cannot be created. Parent node does not exist.");
        }
        String parentPath = fullPath.substring(0, index);
        AugeasNode parentNode = this.getNode(parentPath);
        node = new AugeasNodeReal(parentNode, this, fullPath);
        node.setValue(this.get(fullPath));
        List<AugeasNode> childs = this.match(fullPath + '/' + "*");
        for (AugeasNode chd : childs) {
            node.addChildNode(chd);
        }
        this.getNodeBuffer().addNode(node);
        return node;
    }

    @Override
    public void removeNode(AugeasNode node, boolean updateSeq) throws AugeasTreeException {
        int seq = node.getSeq();
        List<AugeasNode> nodes = this.matchRelative(node.getParentNode(), '/' + node.getLabel() + "[position() > " + String.valueOf(seq) + "]");
        for (AugeasNode nds : nodes) {
            nds.setSeq(nds.getSeq() - 1);
            nds.updateFromParent();
        }
        this.getAugeas().remove(node.getFullPath());
        this.getNodeBuffer().removeNode(node, updateSeq, false);
    }
}

