/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.augeas;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.util.Glob;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.augeas.AugeasConfigurationComponent;

public class AugeasConfigurationDiscoveryComponent<T extends ResourceComponent>
implements ResourceDiscoveryComponent<T>,
ManualAddFacet<T> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<T> discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>(1);
        List<String> includes = this.determineIncludeGlobs(discoveryContext);
        List<String> excludes = this.determineExcludeGlobs(discoveryContext);
        Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
        PropertySimple includeProps = AugeasConfigurationDiscoveryComponent.getGlobList("configurationFilesInclusionPatterns", includes);
        PropertySimple excludeProps = AugeasConfigurationDiscoveryComponent.getGlobList("configurationFilesExclusionPatterns", excludes);
        pluginConfig.put((Property)includeProps);
        pluginConfig.put((Property)excludeProps);
        try {
            this.checkFiles(pluginConfig);
            DiscoveredResourceDetails resource = this.createResourceDetails(discoveryContext, pluginConfig);
            discoveredResources.add(resource);
            this.log.debug((Object)("Discovered " + discoveryContext.getResourceType().getName() + " Resource with key [" + resource.getResourceKey() + "]."));
        }
        catch (IllegalStateException e) {
            this.log.warn((Object)("Discovery failed: " + e.getMessage()));
        }
        return discoveredResources;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext<T> discoveryContext) throws InvalidPluginConfigurationException {
        this.checkFiles(pluginConfig);
        DiscoveredResourceDetails resource = this.createResourceDetails(discoveryContext, pluginConfig);
        return resource;
    }

    protected DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext<T> discoveryContext, Configuration pluginConfig) {
        ResourceType resourceType = discoveryContext.getResourceType();
        String resourceKey = this.composeResourceKey(pluginConfig);
        DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceType.getName(), null, resourceType.getDescription(), pluginConfig, null);
        return resource;
    }

    protected List<String> determineIncludeGlobs(ResourceDiscoveryContext<T> discoveryContext) {
        Configuration pluginConfiguration = discoveryContext.getDefaultPluginConfiguration();
        PropertySimple includeGlobsProp = pluginConfiguration.getSimple("configurationFilesInclusionPatterns");
        List<String> ret = AugeasConfigurationDiscoveryComponent.getGlobList(includeGlobsProp);
        if (ret == null || ret.size() == 0) {
            throw new IllegalStateException("Expecting at least once inclusion pattern for configuration files.");
        }
        return ret;
    }

    protected List<String> determineExcludeGlobs(ResourceDiscoveryContext<T> discoveryContext) {
        Configuration pluginConfiguration = discoveryContext.getDefaultPluginConfiguration();
        PropertySimple excludeGlobsProp = pluginConfiguration.getSimple("configurationFilesExclusionPatterns");
        List<String> ret = AugeasConfigurationDiscoveryComponent.getGlobList(excludeGlobsProp);
        return ret;
    }

    private void checkFiles(Configuration pluginConfiguration) {
        PropertySimple includeGlobsProp = pluginConfiguration.getSimple("configurationFilesInclusionPatterns");
        PropertySimple excludeGlobsProp = pluginConfiguration.getSimple("configurationFilesExclusionPatterns");
        String augeasRootPath = pluginConfiguration.getSimpleValue("augeasRootPath", AugeasConfigurationComponent.DEFAULT_AUGEAS_ROOT_PATH);
        File root = new File(augeasRootPath);
        List<String> includeGlobs = AugeasConfigurationDiscoveryComponent.getGlobList(includeGlobsProp);
        if (includeGlobsProp == null) {
            throw new IllegalStateException("Expecting at least one inclusion pattern for configuration files.");
        }
        List<File> files = Glob.matchAll(root, includeGlobs, Glob.ALPHABETICAL_COMPARATOR);
        if (excludeGlobsProp != null) {
            List<String> excludeGlobs = AugeasConfigurationDiscoveryComponent.getGlobList(excludeGlobsProp);
            Glob.excludeAll(files, excludeGlobs);
        }
        for (File configFile : files) {
            if (!configFile.isAbsolute()) {
                throw new IllegalStateException("Configuration files inclusion patterns contain a non-absolute file.");
            }
            if (!configFile.exists()) {
                throw new IllegalStateException("Configuration files inclusion patterns refer to a non-existent file.");
            }
            if (!configFile.isDirectory()) continue;
            throw new IllegalStateException("Configuration files inclusion patterns refer to a directory.");
        }
    }

    private String composeResourceKey(Configuration pluginConfiguration) {
        PropertySimple includeGlobsProp = pluginConfiguration.getSimple("configurationFilesInclusionPatterns");
        PropertySimple excludeGlobsProp = pluginConfiguration.getSimple("configurationFilesExclusionPatterns");
        StringBuilder bld = new StringBuilder();
        bld.append(includeGlobsProp.getStringValue());
        if (excludeGlobsProp != null && excludeGlobsProp.getStringValue().length() > 0) {
            bld.append("---");
            bld.append(excludeGlobsProp.getStringValue());
        }
        return bld.toString();
    }

    public static PropertySimple getGlobList(String name, List<String> simples) {
        StringBuilder bld = new StringBuilder();
        if (simples != null) {
            for (String s : simples) {
                bld.append(s).append("|");
            }
        }
        if (bld.length() > 0) {
            bld.deleteCharAt(bld.length() - 1);
        }
        return new PropertySimple(name, (Object)bld);
    }

    public static List<String> getGlobList(PropertySimple list) {
        if (list != null) {
            return Arrays.asList(list.getStringValue().split("\\s*\\|\\s*"));
        }
        return Collections.emptyList();
    }
}

