/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.rhqtransform.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.augeas.Augeas;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.config.AugeasConfiguration;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.util.Glob;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.rhqtransform.AugeasRhqException;

public class PluginDescriptorBasedAugeasConfiguration
implements AugeasConfiguration {
    public static final String INCLUDE_GLOBS_PROP = "configurationFilesInclusionPatterns";
    public static final String EXCLUDE_GLOBS_PROP = "configurationFilesExclusionPatterns";
    public static final String AUGEAS_MODULE_NAME_PROP = "augeasModuleName";
    public static final String AUGEAS_LOAD_PATH = "augeasLoadPath";
    public static final String DEFAULT_AUGEAS_ROOT_PATH = File.listRoots()[0].getPath();
    public static final String DEFAULT_AUGEAS_LOAD_PATH = "/usr/share/augeas/lenses";
    private final Log log = LogFactory.getLog(this.getClass());
    protected List<AugeasModuleConfig> modules;
    protected String loadPath;

    public PluginDescriptorBasedAugeasConfiguration(String path, Configuration pluginConfiguration) throws AugeasRhqException {
        List<String> includes = this.determineGlobs(pluginConfiguration, INCLUDE_GLOBS_PROP);
        List<String> excludes = this.determineGlobs(pluginConfiguration, EXCLUDE_GLOBS_PROP);
        this.modules = new ArrayList<AugeasModuleConfig>();
        if (includes.isEmpty()) {
            throw new AugeasRhqException("At least one Include glob must be defined.");
        }
        try {
            this.loadPath = pluginConfiguration.getSimpleValue(AUGEAS_LOAD_PATH, "");
            if (this.loadPath.equals("")) {
                this.loadPath = path;
            }
            AugeasModuleConfig config = new AugeasModuleConfig();
            config.setIncludedGlobs(includes);
            config.setExcludedGlobs(excludes);
            config.setLensPath(this.getAugeasModuleName(pluginConfiguration) + ".lns");
            config.setModuletName(this.getAugeasModuleName(pluginConfiguration));
            this.modules.add(config);
        }
        catch (Exception e) {
            this.log.error((Object)"Creation of temporary Directory for augeas lens failed.");
            throw new AugeasRhqException("Creation of temporary Directory for augeas lens failed.", e);
        }
    }

    protected List<String> determineGlobs(Configuration configuration, String name) {
        PropertySimple includeGlobsProp = configuration.getSimple(name);
        if (includeGlobsProp == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(PluginDescriptorBasedAugeasConfiguration.getGlobList(includeGlobsProp));
        return ret;
    }

    protected String getAugeasModuleName(Configuration configuration) {
        return configuration.getSimpleValue(AUGEAS_MODULE_NAME_PROP, null);
    }

    public static PropertySimple getGlobList(String name, List<String> simples) {
        StringBuilder bld = new StringBuilder();
        if (simples != null) {
            for (String s : simples) {
                bld.append(s).append("|");
            }
        }
        if (bld.length() > 0) {
            bld.deleteCharAt(bld.length() - 1);
        }
        return new PropertySimple(name, (Object)bld);
    }

    public static List<String> getGlobList(PropertySimple list) {
        if (list != null && list.getStringValue() != null) {
            return Arrays.asList(list.getStringValue().split("\\s*\\|\\s*"));
        }
        return Collections.emptyList();
    }

    public Configuration updateConfiguration(Configuration configuration) throws AugeasRhqException {
        if (this.modules.isEmpty()) {
            throw new AugeasRhqException("Error in augeas Configuration.");
        }
        AugeasModuleConfig tempModule = this.modules.get(0);
        PropertySimple includeProps = PluginDescriptorBasedAugeasConfiguration.getGlobList(INCLUDE_GLOBS_PROP, tempModule.getIncludedGlobs());
        PropertySimple excludeProps = PluginDescriptorBasedAugeasConfiguration.getGlobList(EXCLUDE_GLOBS_PROP, tempModule.getExcludedGlobs());
        configuration.put((Property)includeProps);
        configuration.put((Property)excludeProps);
        return configuration;
    }

    @Override
    public String getLoadPath() {
        return this.loadPath;
    }

    @Override
    public int getMode() {
        return Augeas.NO_MODL_AUTOLOAD;
    }

    @Override
    public List<AugeasModuleConfig> getModules() {
        return this.modules;
    }

    @Override
    public String getRootPath() {
        return DEFAULT_AUGEAS_ROOT_PATH;
    }

    @Override
    public AugeasModuleConfig getModuleByName(String name) {
        for (AugeasModuleConfig module : this.modules) {
            if (!module.getModuletName().equals(name)) continue;
            return module;
        }
        return null;
    }

    @Override
    public void loadFiles() {
        File root = new File(this.getRootPath());
        for (AugeasModuleConfig module : this.modules) {
            List<String> includeGlobs = module.getIncludedGlobs();
            if (includeGlobs.size() <= 0) {
                throw new IllegalStateException("Expecting at least once inclusion pattern for configuration files.");
            }
            List<File> files = Glob.matchAll(root, includeGlobs, Glob.ALPHABETICAL_COMPARATOR);
            if (module.getExcludedGlobs() != null) {
                List<String> excludeGlobs = module.getExcludedGlobs();
                Glob.excludeAll(files, excludeGlobs);
            }
            for (File configFile : files) {
                if (!configFile.isAbsolute()) {
                    throw new IllegalStateException("Configuration files inclusion patterns contain a non-absolute file.");
                }
                if (!configFile.exists()) {
                    throw new IllegalStateException("Configuration files inclusion patterns refer to a non-existent file.");
                }
                if (configFile.isDirectory()) {
                    throw new IllegalStateException("Configuration files inclusion patterns refer to a directory.");
                }
                if (module.getConfigFiles().contains(configFile.getAbsolutePath())) continue;
                module.addConfigFile(configFile.getAbsolutePath());
            }
        }
    }
}

