/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PropertiesGenerator {
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private boolean update;
    private File xmlFile;
    private File propertiesFile;
    private PrintWriter contentWriter;
    private Properties previousProperties = new Properties();
    private static Map<String, String> TAG_KEY_ATTRIBUTES = new HashMap<String, String>();
    private static Map<String, Set<String>> TAG_LOCALIZED_ATTRIBUTES = new HashMap<String, Set<String>>();

    public static Set<String> getLocalizedAttributes(String tagName) {
        return TAG_LOCALIZED_ATTRIBUTES.get(tagName);
    }

    public PropertiesGenerator(File xmlFile, File propertiesFile, boolean update) {
        this.xmlFile = xmlFile;
        this.propertiesFile = propertiesFile;
        this.update = update;
    }

    private static void putLocalization(String tagName, String ... attributes) {
        HashSet<String> lp = new HashSet<String>();
        for (String attr : attributes) {
            lp.add(attr);
        }
        TAG_LOCALIZED_ATTRIBUTES.put(tagName, lp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateI18NProperties() {
        try {
            if (this.update) {
                this.previousProperties = new Properties();
                this.previousProperties.load(new FileInputStream(this.propertiesFile));
                this.contentWriter.println("\n\n# Contents added " + new Date() + "\n\n");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(this.xmlFile);
            FileOutputStream fos = new FileOutputStream(this.propertiesFile, this.update);
            this.contentWriter = new PrintWriter(fos);
            this.generateNode(doc.getDocumentElement(), "");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            if (this.contentWriter != null) {
                this.contentWriter.close();
            }
        }
    }

    private void generateNode(Element element, String partialKey) {
        String tagKey;
        String childKey = partialKey + element.getTagName();
        String keyAttribute = TAG_KEY_ATTRIBUTES.get(element.getNodeName());
        if (keyAttribute == null) {
            keyAttribute = "name";
        }
        childKey = (tagKey = element.getAttribute(keyAttribute)) != null && tagKey.length() > 0 ? childKey + "[" + tagKey + "]." : childKey + ".";
        this.generateAtributes(element, childKey);
        this.generateChildren(element, childKey);
    }

    private void generateChildren(Element element, String partialKey) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (!(child instanceof Element)) continue;
            this.generateNode((Element)child, partialKey);
        }
    }

    private void generateAtributes(Element element, String partialKey) {
        if (element.getNodeName().equals("server") || element.getNodeName().equals("service")) {
            this.contentWriter.println();
        }
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node n = attrs.item(i);
            Set<String> localizedProperties = TAG_LOCALIZED_ATTRIBUTES.get(element.getTagName());
            if (localizedProperties == null || !localizedProperties.contains(n.getNodeName())) continue;
            String key = partialKey + n.getNodeName();
            String value = "    # " + n.getNodeValue();
            if (this.previousProperties.containsKey(key)) continue;
            this.contentWriter.println(key + "=" + value);
            this.properties.put(key, value);
        }
    }

    static {
        PropertiesGenerator.putLocalization("plugin", "displayName");
        PropertiesGenerator.putLocalization("server", "displayName", "description");
        PropertiesGenerator.putLocalization("service", "displayName", "description");
        PropertiesGenerator.putLocalization("simple-property", "displayName", "description");
        PropertiesGenerator.putLocalization("list-property", "displayName", "description");
        PropertiesGenerator.putLocalization("map-property", "displayName", "description");
        PropertiesGenerator.putLocalization("artifact", "displayName", "description");
        TAG_KEY_ATTRIBUTES.put("metric", "property");
        PropertiesGenerator.putLocalization("metric", "displayName", "description");
        PropertiesGenerator.putLocalization("operation", "displayName");
    }
}

