/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildListener;
import org.rhq.bundle.ant.AntLauncher;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.bundle.ant.DeploymentPhase;
import org.rhq.bundle.ant.InvalidBuildFileException;
import org.rhq.bundle.ant.LoggerAntBuildListener;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.bundle.BundleDeployRequest;
import org.rhq.core.pluginapi.bundle.BundleDeployResult;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;
import org.rhq.core.pluginapi.bundle.BundlePurgeRequest;
import org.rhq.core.pluginapi.bundle.BundlePurgeResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeployDifferences;
import org.rhq.core.util.updater.DeploymentsMetadata;
import org.rhq.core.util.updater.FileHashcodeMap;
import org.rhq.plugins.ant.DeploymentAuditorBuildListener;

public class AntBundlePluginComponent
implements ResourceComponent,
BundleFacet {
    private final Log log = LogFactory.getLog(AntBundlePluginComponent.class);
    private ResourceContext resourceContext;
    private File tmpDirectory;

    public void start(ResourceContext context) throws Exception {
        this.resourceContext = context;
        this.tmpDirectory = new File(context.getTemporaryDirectory(), "ant-bundle-plugin");
        this.tmpDirectory.mkdirs();
        if (!this.tmpDirectory.exists() || !this.tmpDirectory.isDirectory()) {
            throw new Exception("Failed to create tmp dir [" + this.tmpDirectory + "] - cannot process Ant bundles.");
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public BundleDeployResult deployBundle(BundleDeployRequest request) {
        BundleDeployResult result = new BundleDeployResult();
        try {
            BundleResourceDeployment resourceDeployment = request.getResourceDeployment();
            BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
            BundleVersion bundleVersion = bundleDeployment.getBundleVersion();
            String recipe = bundleVersion.getRecipe();
            File recipeFile = File.createTempFile("ant-bundle-recipe", ".xml", request.getBundleFilesLocation());
            File logFile = File.createTempFile("ant-bundle-recipe", ".log", this.tmpDirectory);
            PrintWriter logFileOutput = null;
            try {
                logFileOutput = new PrintWriter(new FileOutputStream(logFile, true));
                ByteArrayInputStream in = new ByteArrayInputStream(recipe.getBytes());
                FileOutputStream out = new FileOutputStream(recipeFile);
                StreamUtil.copy((InputStream)in, (OutputStream)out);
                Properties antProps = this.createAntProperties(request);
                ArrayList<BuildListener> buildListeners = new ArrayList<BuildListener>();
                LoggerAntBuildListener logger = new LoggerAntBuildListener(null, logFileOutput, 4);
                buildListeners.add((BuildListener)logger);
                DeploymentAuditorBuildListener auditor = new DeploymentAuditorBuildListener(request.getBundleManagerProvider(), resourceDeployment);
                buildListeners.add(auditor);
                this.executeDeploymentPhase(recipeFile, antProps, buildListeners, DeploymentPhase.STOP);
                String deployDirString = bundleDeployment.getDestination().getDeployDir();
                File deployDir = new File(deployDirString);
                DeploymentsMetadata deployMetadata = new DeploymentsMetadata(deployDir);
                DeploymentPhase installPhase = deployMetadata.isManaged() ? DeploymentPhase.UPGRADE : DeploymentPhase.INSTALL;
                BundleAntProject project = this.executeDeploymentPhase(recipeFile, antProps, buildListeners, installPhase);
                this.executeDeploymentPhase(recipeFile, antProps, buildListeners, DeploymentPhase.START);
                BundleManagerProvider bundleManagerProvider = request.getBundleManagerProvider();
                DeployDifferences diffs = project.getDeployDifferences();
                String msg = "Added files=" + diffs.getAddedFiles().size() + "; Deleted files=" + diffs.getDeletedFiles().size() + " (see attached details for more information)";
                String fullDetails = this.formatDiff(diffs);
                bundleManagerProvider.auditDeployment(resourceDeployment, "Deployment Differences", project.getName(), BundleResourceDeploymentHistory.Category.DEPLOY_STEP, null, msg, fullDetails);
            }
            catch (Throwable t) {
                if (this.log.isDebugEnabled()) {
                    try {
                        this.log.debug((Object)new String(StreamUtil.slurp((InputStream)new FileInputStream(logFile))));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw new Exception("Failed to execute the bundle Ant script", t);
            }
            finally {
                if (logFileOutput != null) {
                    logFileOutput.close();
                }
                recipeFile.delete();
                logFile.delete();
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to deploy bundle [" + request + "]"), t);
            result.setErrorMessage(t);
        }
        return result;
    }

    public BundlePurgeResult purgeBundle(BundlePurgeRequest request) {
        BundlePurgeResult result = new BundlePurgeResult();
        try {
            BundleResourceDeployment deploymentToPurge = request.getLiveResourceDeployment();
            BundleDeployment bundleDeployment = deploymentToPurge.getBundleDeployment();
            File deployDir = new File(bundleDeployment.getDestination().getDeployDir());
            String deployDirAbsolutePath = deployDir.getAbsolutePath();
            BundleManagerProvider bundleManagerProvider = request.getBundleManagerProvider();
            boolean manageAllDeployDir = true;
            boolean errorPurgingDeployDirContent = false;
            File metadataDirectoryToPurge = null;
            DeploymentsMetadata metadata = new DeploymentsMetadata(deployDir);
            if (metadata.isManaged()) {
                metadataDirectoryToPurge = metadata.getMetadataDirectory();
                manageAllDeployDir = metadata.getCurrentDeploymentProperties().getManageRootDir();
                int totalExternalFiles = 0;
                ArrayList<String> externalDeleteSuccesses = new ArrayList<String>(0);
                ArrayList<String> externalDeleteFailures = new ArrayList<String>(0);
                FileHashcodeMap deployDirFileHashcodes = metadata.getCurrentDeploymentFileHashcodes();
                for (String filePath : deployDirFileHashcodes.keySet()) {
                    File file = new File(filePath);
                    if (file.isAbsolute()) {
                        ++totalExternalFiles;
                        if (file.exists()) {
                            if (file.delete()) {
                                externalDeleteSuccesses.add(filePath);
                                continue;
                            }
                            externalDeleteFailures.add(filePath);
                            continue;
                        }
                        externalDeleteSuccesses.add(filePath);
                        continue;
                    }
                    String parentDir = file.getParent();
                    if (parentDir == null) {
                        file = new File(deployDir, filePath);
                        file.delete();
                    } else {
                        file = new File(deployDir, parentDir);
                        FileUtil.purge((File)file, (boolean)true);
                    }
                    if (!file.exists()) continue;
                    errorPurgingDeployDirContent = true;
                }
                if (totalExternalFiles > 0) {
                    if (!externalDeleteSuccesses.isEmpty()) {
                        StringBuilder deleteSuccessesDetails = new StringBuilder();
                        for (String path : externalDeleteSuccesses) {
                            deleteSuccessesDetails.append(path).append("\n");
                        }
                        bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "External files were purged", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.SUCCESS, "[" + externalDeleteSuccesses.size() + "] of [" + totalExternalFiles + "] external files were purged. See attached details for the list", deleteSuccessesDetails.toString());
                    }
                    if (!externalDeleteFailures.isEmpty()) {
                        StringBuilder deleteFailuresDetails = new StringBuilder();
                        for (String path : externalDeleteFailures) {
                            deleteFailuresDetails.append(path).append("\n");
                        }
                        bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "External files failed to be purged", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.FAILURE, "[" + externalDeleteFailures.size() + "] of [" + totalExternalFiles + "] external files failed to be purged. See attached details for the list", deleteFailuresDetails.toString());
                    }
                }
            }
            if (manageAllDeployDir) {
                FileUtil.purge((File)deployDir, (boolean)true);
                if (!deployDir.exists()) {
                    bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "The destination directory has been purged", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.SUCCESS, "Directory purged: " + deployDirAbsolutePath, null);
                } else {
                    bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "The destination directory failed to be purged", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.FAILURE, "The directory that failed to be purged: " + deployDirAbsolutePath, null);
                }
            } else {
                if (!errorPurgingDeployDirContent) {
                    bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "The managed bundle content was removed from the destination directory; other unmanaged content may still remain", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.SUCCESS, "Deploy Directory: " + deployDirAbsolutePath, null);
                } else {
                    bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "Not all managed bundle content was able to be removed from the destination directory. That managed content along with other unmanaged content still remain", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.FAILURE, "Deploy Directory: " + deployDirAbsolutePath, null);
                }
                if (metadataDirectoryToPurge != null) {
                    FileUtil.purge((File)metadataDirectoryToPurge, (boolean)true);
                    if (metadataDirectoryToPurge.exists()) {
                        bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "Failed to purge the metadata directory from the destination directory. It may still contain backed up files from previous bundle deployments.", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.FAILURE, "Metadata Directory: " + metadataDirectoryToPurge.getAbsolutePath(), null);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to purge bundle [" + request + "]"), t);
            result.setErrorMessage(t);
        }
        return result;
    }

    private BundleAntProject executeDeploymentPhase(File recipeFile, Properties antProps, List<BuildListener> buildListeners, DeploymentPhase phase) throws InvalidBuildFileException {
        AntLauncher antLauncher = new AntLauncher();
        antProps.setProperty("rhq.deploy.phase", phase.name());
        BundleAntProject project = antLauncher.executeBundleDeployFile(recipeFile, antProps, buildListeners);
        return project;
    }

    private Properties createAntProperties(BundleDeployRequest request) {
        Properties antProps = new Properties();
        BundleResourceDeployment resourceDeployment = request.getResourceDeployment();
        BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
        String deployDir = bundleDeployment.getDestination().getDeployDir();
        if (deployDir == null) {
            throw new IllegalStateException("Bundle deployment does not specify install dir: " + bundleDeployment);
        }
        antProps.setProperty("rhq.deploy.dir", deployDir);
        int deploymentId = bundleDeployment.getId();
        antProps.setProperty("rhq.deploy.id", Integer.toString(deploymentId));
        antProps.setProperty("rhq.deploy.name", bundleDeployment.getName());
        antProps.setProperty("rhq.deploy.revert", String.valueOf(request.isRevert()));
        antProps.setProperty("rhq.deploy.clean", String.valueOf(request.isCleanDeployment()));
        Map sysFacts = SystemInfoFactory.fetchTemplateEngine().getTokens();
        for (Map.Entry fact : sysFacts.entrySet()) {
            antProps.setProperty((String)fact.getKey(), (String)fact.getValue());
        }
        Configuration config = bundleDeployment.getConfiguration();
        if (config != null) {
            Map allProperties = config.getAllProperties();
            for (Map.Entry entry : allProperties.entrySet()) {
                String name = (String)entry.getKey();
                Property prop = (Property)entry.getValue();
                if (!(prop instanceof PropertySimple)) continue;
                String value = ((PropertySimple)prop).getStringValue();
                antProps.setProperty(name, value);
            }
        }
        return antProps;
    }

    private String formatDiff(DeployDifferences diffs) {
        String indent = "    ";
        String nl = "\n";
        StringBuilder str = new StringBuilder("DEPLOYMENT DETAILS:");
        str.append(nl);
        str.append("Added Files: ").append(diffs.getAddedFiles().size()).append(nl);
        for (String string : diffs.getAddedFiles()) {
            str.append(indent).append(string).append(nl);
        }
        str.append("Deleted Files: ").append(diffs.getDeletedFiles().size()).append(nl);
        for (String string : diffs.getDeletedFiles()) {
            str.append(indent).append(string).append(nl);
        }
        str.append("Changed Files: ").append(diffs.getChangedFiles().size()).append(nl);
        for (String string : diffs.getChangedFiles()) {
            str.append(indent).append(string).append(nl);
        }
        str.append("Backed Up Files: ").append(diffs.getBackedUpFiles().size()).append(nl);
        for (Map.Entry entry : diffs.getBackedUpFiles().entrySet()) {
            str.append(indent).append((String)entry.getKey()).append(" -> ").append((String)entry.getValue()).append(nl);
        }
        str.append("Restored Files: ").append(diffs.getRestoredFiles().size()).append(nl);
        for (Map.Entry entry : diffs.getRestoredFiles().entrySet()) {
            str.append(indent).append((String)entry.getKey()).append(" <- ").append((String)entry.getValue()).append(nl);
        }
        str.append("Ignored Files: ").append(diffs.getIgnoredFiles().size()).append(nl);
        for (String string : diffs.getIgnoredFiles()) {
            str.append(indent).append(string).append(nl);
        }
        str.append("Realized Files: ").append(diffs.getRealizedFiles().size()).append(nl);
        for (String string : diffs.getRealizedFiles().keySet()) {
            str.append(indent).append(string).append(nl);
        }
        str.append("Was Cleaned?: ").append(diffs.wasCleaned()).append(nl);
        str.append("Errors: ").append(diffs.getErrors().size()).append(nl);
        for (Map.Entry entry : diffs.getErrors().entrySet()) {
            str.append(indent).append((String)entry.getKey()).append(" : ").append((String)entry.getValue()).append(nl);
        }
        return str.toString();
    }
}

