/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.EmsException;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public abstract class AbstractMessagingDiscoveryComponent
extends MBeanResourceDiscoveryComponent<JMXComponent> {
    protected Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context, String objectName, String resourceName, String resourceDescription, String versionSource) {
        HashSet<DiscoveredResourceDetails> result = new HashSet<DiscoveredResourceDetails>();
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectName);
        JMXComponent parentResourceComponent = (JMXComponent)context.getParentResourceComponent();
        EmsConnection connection = parentResourceComponent.getEmsConnection();
        Configuration pluginConfig = context.getDefaultPluginConfiguration();
        List beans = connection.queryBeans(queryUtility.getTranslatedQuery());
        if (beans.size() == 1) {
            String version = this.getVersionFromSource(connection, versionSource);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), objectName, resourceName, version, resourceDescription, pluginConfig, null);
            result.add(detail);
        }
        return result;
    }

    private String getVersionFromSource(EmsConnection connection, String versionSource) {
        int pos = versionSource.indexOf(59);
        if (pos < 0) {
            return null;
        }
        String beanName = versionSource.substring(0, pos);
        String attribs = versionSource.substring(pos + 1);
        String[] attrs = attribs.split(",");
        try {
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(beanName);
            List beans = connection.queryBeans(queryUtility.getTranslatedQuery());
            if (beans.size() == 1) {
                EmsBean bean = (EmsBean)beans.get(0);
                bean.refreshAttributes(Arrays.asList(attrs));
                StringBuilder ret = new StringBuilder();
                Iterator<String> iter = Arrays.asList(attrs).iterator();
                while (iter.hasNext()) {
                    String att = iter.next();
                    EmsAttribute eatt = bean.getAttribute(att);
                    ret.append((String)eatt.getValue());
                    if (!iter.hasNext()) continue;
                    ret.append(" ");
                }
                return ret.toString();
            }
            return null;
        }
        catch (EmsException ee) {
            return null;
        }
        catch (RuntimeException nse) {
            return null;
        }
    }
}

