/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.measurement.calltime.CallTimeDataValue;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class EJB2BeanComponent
extends MBeanResourceComponent<JBossASServerComponent> {
    private final Log log = LogFactory.getLog(EJB2BeanComponent.class);
    private Map<Integer, CallTimeData> previousRawCallTimeDatas = new HashMap<Integer, CallTimeData>();

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) {
        LinkedHashSet<MeasurementScheduleRequest> numericMetricSchedules = new LinkedHashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest schedule : schedules) {
            Object statelessSessionBeanStats;
            if (schedule.getDataType() == DataType.MEASUREMENT) {
                numericMetricSchedules.add(schedule);
                continue;
            }
            if (!schedule.getName().equals("MethodInvocationTime")) continue;
            try {
                statelessSessionBeanStats = this.getStatelessSessionBeanStats();
            }
            catch (Exception e) {
                continue;
            }
            try {
                Map<String, Stat> stats = this.getStats(statelessSessionBeanStats);
                Date lastResetTime = this.getLastResetTime(statelessSessionBeanStats);
                Date now = new Date(System.currentTimeMillis());
                if (stats.isEmpty()) continue;
                CallTimeData callTimeData = this.createCallTimeData(schedule, stats, lastResetTime, now);
                report.addData(callTimeData);
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to retrieve EJB2 call-time data.", (Throwable)e);
            }
        }
        super.getValues(report, numericMetricSchedules);
    }

    private CallTimeData createCallTimeData(MeasurementScheduleRequest schedule, Map<String, Stat> stats, Date lastResetTime, Date collectionTime) throws Exception {
        CallTimeData previousRawCallTimeData = this.previousRawCallTimeDatas.get(schedule.getScheduleId());
        CallTimeData rawCallTimeData = new CallTimeData(schedule);
        this.previousRawCallTimeDatas.put(schedule.getScheduleId(), rawCallTimeData);
        CallTimeData callTimeData = new CallTimeData(schedule);
        for (String methodName : stats.keySet()) {
            long countSincePrevious;
            Stat timeStatistic = stats.get(methodName);
            long minTime = timeStatistic.min;
            long maxTime = timeStatistic.max;
            long totalTime = timeStatistic.total;
            long count = timeStatistic.count;
            try {
                rawCallTimeData.addAggregatedCallData(methodName, lastResetTime, collectionTime, (double)minTime, (double)maxTime, (double)totalTime, count);
            }
            catch (IllegalArgumentException iae) {
                this.log.error((Object)iae);
                continue;
            }
            CallTimeDataValue previousValue = previousRawCallTimeData != null ? (CallTimeDataValue)previousRawCallTimeData.getValues().get(methodName) : null;
            boolean supercedesPrevious = previousValue != null && previousValue.getBeginTime() == lastResetTime.getTime();
            Date beginTime = lastResetTime;
            if (supercedesPrevious && (countSincePrevious = count - previousValue.getCount()) > 0L) {
                beginTime = new Date(previousValue.getEndTime());
                count = countSincePrevious;
                totalTime -= (long)previousValue.getTotal();
            }
            callTimeData.addAggregatedCallData(methodName, beginTime, collectionTime, (double)minTime, (double)maxTime, (double)totalTime, count);
        }
        return callTimeData;
    }

    private Date getLastResetTime(Object statelessSessionBeanStats) throws Exception {
        Method method = statelessSessionBeanStats.getClass().getMethod("getMethodReadyCount", new Class[0]);
        Object methodReadyCountStat = method.invoke(statelessSessionBeanStats, new Object[0]);
        long time = (Long)methodReadyCountStat.getClass().getMethod("getStartTime", new Class[0]).invoke(methodReadyCountStat, new Object[0]);
        return new Date(time);
    }

    private Object getStatelessSessionBeanStats() throws Exception {
        Object statelessSessionBeanStats = null;
        EmsBean emsBean = this.getEmsBean();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(emsBean.getClass().getClassLoader());
        try {
            EmsAttribute attribute = emsBean.getAttribute("stats");
            statelessSessionBeanStats = attribute.refresh();
        }
        catch (RuntimeException e) {
            String msg = "Failed to retrieve EJB2 invocation stats.";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)msg, (Throwable)e);
            } else {
                this.log.info((Object)(msg + " Enable DEBUG logging to see cause."));
            }
            throw new Exception(msg, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return statelessSessionBeanStats;
    }

    private Map<String, Stat> getStats(Object statelessSessionBeanStats) throws Exception {
        HashMap<String, Stat> stats = new HashMap<String, Stat>();
        Method method = statelessSessionBeanStats.getClass().getMethod("getStatistics", new Class[0]);
        Object[] jbossStats = (Object[])method.invoke(statelessSessionBeanStats, new Object[0]);
        if (jbossStats != null) {
            for (Object jbossStat : jbossStats) {
                Class<?> clazz = jbossStat.getClass();
                if (!clazz.getSimpleName().contains("TimeStatistic")) continue;
                Stat newStat = new Stat();
                newStat.name = (String)clazz.getMethod("getName", new Class[0]).invoke(jbossStat, new Object[0]);
                newStat.count = (Long)clazz.getMethod("getCount", new Class[0]).invoke(jbossStat, new Object[0]);
                newStat.min = (Long)clazz.getMethod("getMinTime", new Class[0]).invoke(jbossStat, new Object[0]);
                newStat.max = (Long)clazz.getMethod("getMaxTime", new Class[0]).invoke(jbossStat, new Object[0]);
                newStat.total = (Long)clazz.getMethod("getTotalTime", new Class[0]).invoke(jbossStat, new Object[0]);
                newStat.startTime = (Long)clazz.getMethod("getStartTime", new Class[0]).invoke(jbossStat, new Object[0]);
                newStat.lastSampleTime = (Long)clazz.getMethod("getLastSampleTime", new Class[0]).invoke(jbossStat, new Object[0]);
                stats.put(newStat.name, newStat);
            }
        }
        return stats;
    }

    class Stat {
        String name;
        long count;
        long min;
        long max;
        long total;
        long startTime;
        long lastSampleTime;

        Stat() {
        }
    }
}

