/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.mysql.MySqlComponent;

public class MySqlDatabaseDiscoveryComponent
implements ResourceDiscoveryComponent<MySqlComponent> {
    private Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<MySqlComponent> context) {
        LinkedHashSet<DiscoveredResourceDetails> databases;
        block7: {
            block8: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Database discovery started");
                }
                databases = new LinkedHashSet<DiscoveredResourceDetails>();
                Connection connection = ((MySqlComponent)context.getParentResourceComponent()).getConnection();
                Statement statement = null;
                ResultSet resultSet = null;
                if (connection == null) break block8;
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery("SHOW DATABASES");
                    while (resultSet.next()) {
                        String databaseName = resultSet.getString(1);
                        Configuration config = new Configuration();
                        config.put((Property)new PropertySimple("databaseName", (Object)databaseName));
                        DiscoveredResourceDetails details = new DiscoveredResourceDetails(context.getResourceType(), databaseName, databaseName + " Database", null, "A MySql Database", config, null);
                        databases.add(details);
                    }
                }
                catch (SQLException e) {
                    DatabaseQueryUtility.close((Statement)statement, resultSet);
                    break block7;
                    catch (Throwable throwable) {
                        DatabaseQueryUtility.close((Statement)statement, resultSet);
                        throw throwable;
                    }
                }
                DatabaseQueryUtility.close((Statement)statement, (ResultSet)resultSet);
                break block7;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"No connection to MySQL obtained from connection manager");
            }
        }
        return databases;
    }
}

