/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jmx;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class MBeanResourceDiscoveryComponent<T extends JMXComponent>
implements ResourceDiscoveryComponent<T> {
    public static final String PROPERTY_OBJECT_NAME = "objectName";
    public static final String PROPERTY_NAME_TEMPLATE = "nameTemplate";
    public static final String PROPERTY_DESCRIPTION_TEMPLATE = "descriptionTemplate";
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceDiscoveryContext<T> discoveryContext;

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<T> context) {
        return this.discoverResources(context, true);
    }

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<T> context, boolean skipUnknownProps) {
        this.discoveryContext = context;
        return this.performDiscovery(context.getDefaultPluginConfiguration(), (JMXComponent)context.getParentResourceComponent(), context.getResourceType(), skipUnknownProps);
    }

    public Set<DiscoveredResourceDetails> performDiscovery(Configuration pluginConfiguration, JMXComponent parentResourceComponent, ResourceType resourceType) {
        return this.performDiscovery(pluginConfiguration, parentResourceComponent, resourceType, true);
    }

    public Set<DiscoveredResourceDetails> performDiscovery(Configuration pluginConfiguration, JMXComponent parentResourceComponent, ResourceType resourceType, boolean skipUnknownProps) {
        String[] templates;
        String objectNameQueryTemplateOrig = pluginConfiguration.getSimple(PROPERTY_OBJECT_NAME).getStringValue();
        this.log.debug((Object)("Discovering MBean resources with object name query template: " + objectNameQueryTemplateOrig));
        EmsConnection connection = parentResourceComponent.getEmsConnection();
        if (connection == null) {
            throw new NullPointerException("The parent resource component [" + parentResourceComponent + "] returned a null connection - cannot discover MBeans without a connection");
        }
        HashSet<DiscoveredResourceDetails> services = new HashSet<DiscoveredResourceDetails>();
        for (String objectNameQueryTemplate : templates = objectNameQueryTemplateOrig.split("\\|")) {
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectNameQueryTemplate, this.discoveryContext != null ? this.discoveryContext.getParentResourceContext().getPluginConfiguration() : null);
            List beans = connection.queryBeans(queryUtility.getTranslatedQuery());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found [" + beans.size() + "] mbeans for query [" + queryUtility.getTranslatedQuery() + "]."));
            }
            for (EmsBean bean : beans) {
                if (!queryUtility.setMatchedKeyValues(bean.getBeanName().getKeyProperties()) || skipUnknownProps && queryUtility.isContainsExtraKeyProperties(bean.getBeanName().getKeyProperties().keySet())) continue;
                String resourceKey = bean.getBeanName().getCanonicalName();
                String nameTemplate = pluginConfiguration.getSimple(PROPERTY_NAME_TEMPLATE) != null ? pluginConfiguration.getSimple(PROPERTY_NAME_TEMPLATE).getStringValue() : null;
                String descriptionTemplate = pluginConfiguration.getSimple(PROPERTY_DESCRIPTION_TEMPLATE) != null ? pluginConfiguration.getSimple(PROPERTY_DESCRIPTION_TEMPLATE).getStringValue() : null;
                String name = resourceKey;
                if (nameTemplate != null) {
                    name = queryUtility.formatMessage(nameTemplate);
                }
                String description = null;
                if (descriptionTemplate != null) {
                    description = queryUtility.formatMessage(descriptionTemplate);
                }
                DiscoveredResourceDetails service = new DiscoveredResourceDetails(resourceType, resourceKey, name, "", description, null, null);
                Configuration config = service.getPluginConfiguration();
                config.put((Property)new PropertySimple(PROPERTY_OBJECT_NAME, (Object)bean.getBeanName().toString()));
                Map<String, String> mappedVariableValues = queryUtility.getVariableValues();
                for (String key : mappedVariableValues.keySet()) {
                    config.put((Property)new PropertySimple(key, (Object)mappedVariableValues.get(key)));
                }
                services.add(service);
                queryUtility.resetVariables();
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("[" + services.size() + "] services have been added"));
        }
        return services;
    }
}

