/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.rhq.enterprise.server.perspective.RenderedExtension;
import org.rhq.enterprise.server.perspective.activator.ActivatorHelper;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.RenderedExtensionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.TabType;

public class Tab
extends RenderedExtension
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String qualifiedName;
    private List<Tab> children;

    public Tab(TabType rawTab, String perspectiveName) {
        super((RenderedExtensionType)rawTab, perspectiveName, rawTab.getUrl());
        this.name = Tab.getSimpleName(rawTab.getName());
        this.qualifiedName = rawTab.getName();
        if (rawTab.getApplication() != null) {
            this.url = this.url + "&tab=" + this.qualifiedName;
        }
        this.children = new ArrayList<Tab>();
        this.debugMode = ActivatorHelper.initResourceActivators(rawTab.getActivators(), this.getActivators());
    }

    @NotNull
    public List<Tab> getChildren() {
        return this.children;
    }

    public void setChildren(List<Tab> children) {
        this.children = children != null ? children : new ArrayList();
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static String getSimpleName(String qualifiedName) {
        int lastDotIndex = qualifiedName.lastIndexOf(".");
        return qualifiedName.substring(lastDotIndex + 1);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

