/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.util.List;
import java.util.Map;
import javax.ejb.Local;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceAncestryFormat;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.resource.composite.RecentlyAddedResourceComposite;
import org.rhq.core.domain.resource.composite.ResourceAvailabilitySummary;
import org.rhq.core.domain.resource.composite.ResourceComposite;
import org.rhq.core.domain.resource.composite.ResourceHealthComposite;
import org.rhq.core.domain.resource.composite.ResourceIdFlyWeight;
import org.rhq.core.domain.resource.composite.ResourceInstallCount;
import org.rhq.core.domain.resource.composite.ResourceLineageComposite;
import org.rhq.core.domain.resource.composite.ResourceWithAvailability;
import org.rhq.core.domain.resource.flyweight.ResourceFlyweight;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;

@Local
public interface ResourceManagerLocal {
    public void createResource(Subject var1, Resource var2, int var3) throws ResourceAlreadyExistsException;

    public Resource updateResource(Subject var1, Resource var2);

    public List<Integer> uninventoryResource(Subject var1, int var2);

    public void uninventoryResourceAsyncWork(Subject var1, int var2);

    public boolean bulkNativeQueryDeleteInNewTransaction(Subject var1, String var2, List<Integer> var3);

    public boolean bulkNamedQueryDeleteInNewTransaction(Subject var1, String var2, List<Integer> var3);

    public List<Integer> getResourceDescendantsByTypeAndName(Subject var1, int var2, Integer var3, String var4);

    public Resource setResourceStatus(Subject var1, Resource var2, InventoryStatus var3, boolean var4);

    @NotNull
    public Resource getResourceById(Subject var1, int var2);

    @Nullable
    public Resource getParentResource(int var1);

    public List<Integer> getResourceIdLineage(int var1);

    @NotNull
    public List<Resource> getResourceLineage(int var1);

    public List<ResourceLineageComposite> getResourceLineage(Subject var1, int var2);

    public List<ResourceLineageComposite> getResourceLineageAndSiblings(Subject var1, int var2);

    @NotNull
    public Resource getRootResourceForResource(int var1);

    @Nullable
    public Resource getResourceByParentAndKey(Subject var1, @Nullable Resource var2, String var3, String var4, String var5);

    public PageList<Resource> findResourceByParentAndInventoryStatus(Subject var1, Resource var2, InventoryStatus var3, PageControl var4);

    public List<ResourceWithAvailability> findResourcesByParentAndType(Subject var1, Resource var2, ResourceType var3);

    public List<Integer> findChildrenResourceIds(int var1, InventoryStatus var2);

    public PageList<Resource> findChildResourcesByCategoryAndInventoryStatus(Subject var1, Resource var2, ResourceCategory var3, InventoryStatus var4, PageControl var5);

    public PageList<Resource> findResourcesByCategory(Subject var1, ResourceCategory var2, InventoryStatus var3, PageControl var4);

    public PageList<ResourceComposite> findResourceComposites(Subject var1, ResourceCategory var2, String var3, String var4, Resource var5, String var6, boolean var7, PageControl var8);

    public int[] getResourceCountSummary(Subject var1, InventoryStatus var2);

    public int getResourceCountByCategory(Subject var1, ResourceCategory var2, InventoryStatus var3);

    public int getResourceCountByTypeAndIds(Subject var1, ResourceType var2, int[] var3);

    public List<Integer> findResourcesMarkedForAsyncDeletion(Subject var1);

    public List<RecentlyAddedResourceComposite> findRecentlyAddedPlatforms(Subject var1, long var2, int var4);

    public List<RecentlyAddedResourceComposite> findRecentlyAddedServers(Subject var1, long var2, int var4);

    public List<Integer> findExplicitResourceIdsByResourceGroup(int var1);

    public List<Integer> findImplicitResourceIdsByResourceGroup(int var1);

    public List<ResourceIdFlyWeight> findFlyWeights(int[] var1);

    public PageList<Resource> findExplicitResourcesByResourceGroup(Subject var1, ResourceGroup var2, PageControl var3);

    public PageList<Resource> findImplicitResourcesByResourceGroup(Subject var1, ResourceGroup var2, PageControl var3);

    public PageList<ResourceWithAvailability> findExplicitResourceWithAvailabilityByResourceGroup(Subject var1, ResourceGroup var2, PageControl var3);

    public PageList<ResourceWithAvailability> findImplicitResourceWithAvailabilityByResourceGroup(Subject var1, ResourceGroup var2, PageControl var3);

    public PageList<Resource> findAvailableResourcesForResourceGroup(Subject var1, int var2, ResourceType var3, ResourceCategory var4, String var5, int[] var6, PageControl var7);

    public PageList<Resource> findAvailableResourcesForRepo(Subject var1, int var2, String var3, ResourceCategory var4, PageControl var5);

    public PageList<Resource> findAvailableResourcesForDashboardPortlet(Subject var1, Integer var2, ResourceCategory var3, int[] var4, PageControl var5);

    public PageList<Resource> findResourceByIds(Subject var1, int[] var2, boolean var3, PageControl var4);

    public Resource getResourceTree(int var1, boolean var2);

    public PageList<ResourceComposite> findResourceCompositeForParentAndTypeAndCategory(Subject var1, ResourceCategory var2, int var3, Resource var4, PageControl var5);

    @NotNull
    public List<ResourceError> findResourceErrors(Subject var1, int var2, ResourceErrorType var3);

    @NotNull
    public List<ResourceError> findResourceErrors(Subject var1, int var2);

    public void addResourceError(ResourceError var1);

    public void deleteResourceError(Subject var1, int var2);

    public List<AutoGroupComposite> findChildrenAutoGroups(Subject var1, int var2);

    @NotNull
    public List<AutoGroupComposite> findChildrenAutoGroups(Subject var1, int var2, int[] var3);

    public AutoGroupComposite getResourceAutoGroup(Subject var1, int var2);

    public Map<Integer, InventoryStatus> getResourceStatuses(int var1, boolean var2);

    public PageList<ResourceHealthComposite> findResourceHealth(Subject var1, int[] var2, PageControl var3);

    public List<AutoGroupComposite> findResourcesAutoGroups(Subject var1, int[] var2);

    public void clearResourceConfigError(int var1);

    public int clearResourceConfigErrorByType(Subject var1, int var2, ResourceErrorType var3);

    public Resource getPlatform(Agent var1);

    public List<ResourceFlyweight> findResourcesByAgent(Subject var1, int var2, PageControl var3);

    public List<ResourceFlyweight> findResourcesByCompatibleGroup(Subject var1, int var2, PageControl var3);

    public ResourceAvailabilitySummary getAvailabilitySummary(Subject var1, int var2);

    public void updateAncestry(Subject var1, int var2);

    public ResourceAvailability getLiveResourceAvailability(Subject var1, int var2);

    public Resource getResource(Subject var1, int var2);

    public List<Resource> findResourceLineage(Subject var1, int var2);

    public List<Integer> uninventoryResources(Subject var1, int[] var2);

    public List<ResourceInstallCount> findResourceInstallCounts(Subject var1, boolean var2);

    public PageList<ResourceComposite> findResourceCompositesByCriteria(Subject var1, ResourceCriteria var2);

    public PageList<Resource> findResourcesByCriteria(Subject var1, ResourceCriteria var2);

    public PageList<Resource> findChildResources(Subject var1, int var2, PageControl var3);

    public Resource getPlaformOfResource(Subject var1, int var2);

    public Resource getParentResource(Subject var1, int var2);

    public <T> List<DisambiguationReport<T>> disambiguate(List<T> var1, IntExtractor<? super T> var2, DisambiguationUpdateStrategy var3);

    public List<Integer> findIdsByTypeIds(List<Integer> var1);

    public Integer getResourceCount(List<Integer> var1);

    public Map<Integer, String> getResourcesAncestry(Subject var1, Integer[] var2, ResourceAncestryFormat var3);
}

