/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.translation;

import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.search.assist.AlertSearchAssistParam;
import org.rhq.enterprise.server.search.SearchExpressionException;
import org.rhq.enterprise.server.search.common.SearchQueryGenerationUtility;
import org.rhq.enterprise.server.search.translation.AbstractSearchTranslator;
import org.rhq.enterprise.server.search.translation.antlr.RHQLAdvancedTerm;
import org.rhq.enterprise.server.search.translation.antlr.RHQLComparisonOperator;
import org.rhq.enterprise.server.search.translation.jpql.SearchFragment;

public class ResourceSearchTranslator
extends AbstractSearchTranslator {
    public ResourceSearchTranslator(Subject subject) {
        super(subject);
    }

    @Override
    public SearchFragment getSearchFragment(String alias, RHQLAdvancedTerm term) {
        String path = term.getPath();
        RHQLComparisonOperator op = term.getOperator();
        String param = term.getParam();
        String filter = term.getValue();
        if (path.equals("availability")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, this.getJPQLForEnum(alias + ".currentAvailability.availabilityType", op, filter, AvailabilityType.class, true));
        }
        if (path.equals("category")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, this.getJPQLForEnum(alias + ".resourceType.category", op, filter, ResourceCategory.class, false));
        }
        if (path.equals("type")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".resourceType.name", op, filter));
        }
        if (path.equals("plugin")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".resourceType.plugin", op, filter));
        }
        if (path.equals("name")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".name", op, filter));
        }
        if (path.equals("version")) {
            return new SearchFragment(SearchFragment.Type.WHERE_CLAUSE, SearchQueryGenerationUtility.getJPQLForString(alias + ".version", op, filter));
        }
        if (path.equals("alerts")) {
            return new SearchFragment(SearchFragment.Type.PRIMARY_KEY_SUBQUERY, "SELECT res.id  FROM Resource res   JOIN res.alertDefinitions alertDef   JOIN alertDef.alerts alert  WHERE alert.ctime > " + AlertSearchAssistParam.getLastTime((String)param) + (filter.equalsIgnoreCase("any") ? "" : "   and " + this.getJPQLForEnum("alertDef.priority", op, filter, AlertPriority.class, false)) + " GROUP BY res.id " + "HAVING COUNT(alert) > 0 ");
        }
        if (path.equals("trait")) {
            return new SearchFragment(SearchFragment.Type.PRIMARY_KEY_SUBQUERY, "SELECT res.id  FROM Resource res, MeasurementDataTrait trait   JOIN res.schedules schedule  WHERE trait.schedule = schedule    AND schedule.definition.dataType = " + DataType.TRAIT.ordinal() + "   AND " + SearchQueryGenerationUtility.getJPQLForString("schedule.definition.name", RHQLComparisonOperator.EQUALS, param) + "   AND " + SearchQueryGenerationUtility.getJPQLForString("trait.value", op, filter));
        }
        if (path.equals("connection")) {
            return new SearchFragment(SearchFragment.Type.PRIMARY_KEY_SUBQUERY, "SELECT res.id  FROM Resource res, PropertySimple simple, PropertyDefinitionSimple simpleDefinition   JOIN res.resourceType.pluginConfigurationDefinition.propertyDefinitions definition   JOIN res.pluginConfiguration.properties property  WHERE simpleDefinition = definition    AND simpleDefinition.type <> 'PASSWORD'    AND property = simple    AND " + SearchQueryGenerationUtility.getJPQLForString("definition.name", RHQLComparisonOperator.EQUALS, param) + "   AND " + SearchQueryGenerationUtility.getJPQLForString("simple.stringValue", op, filter));
        }
        if (path.equals("configuration")) {
            return new SearchFragment(SearchFragment.Type.PRIMARY_KEY_SUBQUERY, "SELECT res.id  FROM Resource res, PropertySimple simple, PropertyDefinitionSimple simpleDefinition   JOIN res.resourceType.resourceConfigurationDefinition.propertyDefinitions definition   JOIN res.resourceConfiguration.properties property  WHERE simpleDefinition = definition    AND simpleDefinition.type <> 'PASSWORD'    AND property = simple " + this.conditionallyAddAuthzFragment(this.getConfigAuthzFragment()) + "   AND " + SearchQueryGenerationUtility.getJPQLForString("definition.name", RHQLComparisonOperator.EQUALS, param) + "   AND " + SearchQueryGenerationUtility.getJPQLForString("simple.stringValue", op, filter));
        }
        if (param == null) {
            throw new SearchExpressionException("No search fragment available for " + path);
        }
        throw new SearchExpressionException("No search fragment available for " + path + "[" + param + "]");
    }

    private String getConfigAuthzFragment() {
        return "res.id IN (SELECT ires.id    FROM Resource ires    JOIN ires.implicitGroups igroup    JOIN igroup.roles irole    JOIN irole.subjects isubject    JOIN irole.permissions iperm   WHERE isubject.id = " + this.getSubjectId() + "    AND iperm = " + Permission.CONFIGURE_READ.ordinal() + ")";
    }
}

