/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.util.Map;
import mazz.i18n.Msg;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.measurement.MeasurementManager;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.StringUtil;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class SchedulesPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.schedules", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        block6: {
            AgentPrintWriter out = agent.getOut();
            try {
                if (args.length != 2) {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    break block6;
                }
                try {
                    int resourceId = Integer.parseInt(args[1]);
                    MeasurementManager measurementManager = PluginContainer.getInstance().getMeasurementManager();
                    Map nameValuePairs = measurementManager.getMeasurementScheduleInfoForResource(resourceId);
                    if (nameValuePairs == null) {
                        out.println(MSG.getMsg("PromptCommand.schedules.unknown-resource", new Object[]{String.valueOf(resourceId)}));
                        break block6;
                    }
                    out.println(StringUtil.justifyKeyValueStrings(nameValuePairs));
                }
                catch (NumberFormatException nfe) {
                    out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                }
            }
            catch (Exception e) {
                out.println(MSG.getMsg("PromptCommand.schedules.failure", new Object[0]));
                e.printStackTrace(out);
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.schedules.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.schedules.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return this.getHelp();
    }
}

