/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.param;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.param.InvalidParameterDefinitionException;
import org.rhq.enterprise.communications.command.param.Parameter;
import org.rhq.enterprise.communications.command.param.ParameterDefinition;
import org.rhq.enterprise.communications.command.param.ParameterNameIndex;
import org.rhq.enterprise.communications.command.param.ParameterRenderingInformation;
import org.rhq.enterprise.communications.command.param.Parameters;
import org.rhq.enterprise.communications.command.param.SortedParameterNameIndexComparator;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class ParametersImpl
implements Parameters {
    private static final Logger LOG = CommI18NFactory.getLogger(ParametersImpl.class);
    private static final long serialVersionUID = 1L;
    private Map<ParameterNameIndex, Parameter> m_parameters = new HashMap<ParameterNameIndex, Parameter>();
    private int m_lastIndex = -1;

    public ParametersImpl() {
    }

    public ParametersImpl(Parameters original) {
        this();
        if (original != null) {
            for (Parameter parameter : original) {
                this.add(new Parameter(parameter));
            }
        }
    }

    @Override
    public Parameter getParameter(String parameterName) {
        if (parameterName == null) {
            return null;
        }
        return this.m_parameters.get(new ParameterNameIndex(parameterName, -1));
    }

    @Override
    public ParameterDefinition getParameterDefinition(String parameterName) throws InvalidParameterDefinitionException {
        Parameter parameter = this.getParameter(parameterName);
        if (parameter == null) {
            throw new InvalidParameterDefinitionException(LOG.getMsgString("ParametersImpl.no-parameter", new Object[]{parameterName}));
        }
        return parameter.getDefinition();
    }

    @Override
    public Object getParameterValue(String parameterName) throws InvalidParameterDefinitionException {
        Parameter parameter = this.getParameter(parameterName);
        if (parameter == null) {
            throw new InvalidParameterDefinitionException(LOG.getMsgString("ParametersImpl.no-parameter", new Object[]{parameterName}));
        }
        return parameter.getValue();
    }

    @Override
    public void setParameterValue(String parameterName, Object parameterValue) throws InvalidParameterDefinitionException {
        Parameter parameter = this.getParameter(parameterName);
        if (parameter == null) {
            throw new InvalidParameterDefinitionException(LOG.getMsgString("ParametersImpl.no-parameter", new Object[]{parameterName}));
        }
        parameter.setValue(parameterValue);
    }

    @Override
    public Parameters getPublicParameters() {
        return new Proxy(false);
    }

    @Override
    public Parameters getInternalParameters() {
        return new Proxy(true);
    }

    @Override
    public void applyResourceBundleToParameterRenderingInformation(ResourceBundle resourceBundle) {
        for (Parameter param : this) {
            ParameterDefinition definition = param.getDefinition();
            ParameterRenderingInformation renderingInfo = definition.getRenderingInfo();
            renderingInfo.applyResourceBundle(resourceBundle);
        }
    }

    @Override
    public int size() {
        return this.m_parameters.size();
    }

    @Override
    public void clear() {
        this.m_parameters.clear();
        this.m_lastIndex = -1;
    }

    @Override
    public boolean isEmpty() {
        return this.m_parameters.isEmpty();
    }

    @Override
    public boolean add(Parameter parameter) throws NullPointerException {
        if (parameter == null) {
            throw new NullPointerException("parameter=null");
        }
        ++this.m_lastIndex;
        this.m_parameters.put(new ParameterNameIndex(parameter.getDefinition().getName(), this.m_lastIndex), parameter);
        return true;
    }

    @Override
    public boolean contains(Object o) throws ClassCastException, NullPointerException {
        if (o == null) {
            throw new NullPointerException("o=null");
        }
        if (o instanceof String) {
            return this.contains((String)o);
        }
        if (o instanceof Parameter) {
            return this.contains((Parameter)o);
        }
        throw new ClassCastException(LOG.getMsgString("ParametersImpl.must-be-string-or-param", new Object[0]));
    }

    @Override
    public boolean contains(String parameterName) throws NullPointerException {
        if (parameterName == null) {
            throw new NullPointerException("parameterName=null");
        }
        return this.m_parameters.containsKey(new ParameterNameIndex(parameterName, -1));
    }

    @Override
    public boolean contains(Parameter parameter) throws NullPointerException {
        if (parameter == null) {
            throw new NullPointerException("parameter=null");
        }
        return this.contains(parameter.getDefinition().getName());
    }

    @Override
    public boolean remove(Object o) throws ClassCastException, NullPointerException {
        if (o == null) {
            throw new NullPointerException("object=null");
        }
        if (o instanceof String) {
            return this.remove((String)o);
        }
        if (o instanceof Parameter) {
            return this.remove((Parameter)o);
        }
        throw new ClassCastException(LOG.getMsgString("ParametersImpl.must-be-string-or-param", new Object[0]));
    }

    @Override
    public boolean remove(String parameterName) throws NullPointerException {
        if (parameterName == null) {
            throw new NullPointerException("parameterName=null");
        }
        return this.m_parameters.remove(new ParameterNameIndex(parameterName, -1)) != null;
    }

    @Override
    public boolean remove(Parameter parameter) throws NullPointerException {
        if (parameter == null) {
            throw new NullPointerException("parameter=null");
        }
        return this.remove(parameter.getDefinition().getName());
    }

    @Override
    public boolean addAll(Collection<? extends Parameter> c) throws ClassCastException, NullPointerException {
        if (c == null) {
            throw new NullPointerException("c=null");
        }
        boolean changed = false;
        if (!c.isEmpty()) {
            for (Parameter parameter : c) {
                changed |= this.add(parameter);
            }
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> c) throws ClassCastException, NullPointerException {
        if (c == null) {
            throw new NullPointerException("c=null");
        }
        boolean hasAll = true;
        if (!c.isEmpty()) {
            for (Object parameter : c) {
                hasAll &= this.contains(parameter);
            }
        }
        return hasAll;
    }

    @Override
    public boolean removeAll(Collection<?> c) throws ClassCastException, NullPointerException {
        if (c == null) {
            throw new NullPointerException("c=null");
        }
        boolean changed = false;
        if (!c.isEmpty()) {
            for (Object parameter : c) {
                changed |= this.remove(parameter);
            }
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) throws ClassCastException, NullPointerException {
        this.clear();
        for (Object object : c) {
            this.add((Parameter)object);
        }
        return true;
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.getSortedIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Parameter[this.m_parameters.size()];
        System.arraycopy(this.getSortedCollection().toArray(), 0, array, 0, array.length);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getSortedCollection().toArray(a);
    }

    public String toString() {
        return this.m_parameters.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ParametersImpl)) {
            return false;
        }
        return ((Object)this.m_parameters).equals(((ParametersImpl)obj).m_parameters);
    }

    @Override
    public int hashCode() {
        return ((Object)this.m_parameters).hashCode();
    }

    private Collection<Parameter> getSortedCollection() {
        TreeMap<ParameterNameIndex, Parameter> map = new TreeMap<ParameterNameIndex, Parameter>(new SortedParameterNameIndexComparator());
        map.putAll(this.m_parameters);
        return map.values();
    }

    private Iterator<Parameter> getSortedIterator() {
        return this.getSortedCollection().iterator();
    }

    class Proxy
    implements Parameters {
        private static final long serialVersionUID = 1L;
        private final boolean m_onlyHidden;

        Proxy(boolean onlyHidden) {
            this.m_onlyHidden = onlyHidden;
        }

        @Override
        public Parameter getParameter(String parameterName) {
            Parameter retParam = ParametersImpl.this.getParameter(parameterName);
            if (retParam != null && retParam.getDefinition() != null && retParam.getDefinition().isHidden() != this.m_onlyHidden) {
                return null;
            }
            return retParam;
        }

        @Override
        public ParameterDefinition getParameterDefinition(String parameterName) throws InvalidParameterDefinitionException {
            Parameter param = this.getParameter(parameterName);
            if (param == null) {
                throw new InvalidParameterDefinitionException(LOG.getMsgString("ParametersImpl.no-parameter", new Object[]{parameterName}));
            }
            return param.getDefinition();
        }

        @Override
        public Object getParameterValue(String parameterName) throws InvalidParameterDefinitionException {
            Parameter param = this.getParameter(parameterName);
            if (param == null) {
                throw new InvalidParameterDefinitionException(LOG.getMsgString("ParametersImpl.no-parameter", new Object[]{parameterName}));
            }
            return param.getValue();
        }

        @Override
        public void setParameterValue(String parameterName, Object parameterValue) throws InvalidParameterDefinitionException {
            Parameter param = this.getParameter(parameterName);
            if (param == null) {
                throw new InvalidParameterDefinitionException(LOG.getMsgString("ParametersImpl.no-parameter", new Object[]{parameterName}));
            }
            param.setValue(parameterValue);
        }

        @Override
        public Parameters getPublicParameters() {
            return this.m_onlyHidden ? new ParametersImpl() : this;
        }

        @Override
        public Parameters getInternalParameters() {
            return !this.m_onlyHidden ? new ParametersImpl() : this;
        }

        @Override
        public void applyResourceBundleToParameterRenderingInformation(ResourceBundle resourceBundle) {
            for (Parameter param : this) {
                ParameterDefinition definition = param.getDefinition();
                ParameterRenderingInformation renderingInfo = definition.getRenderingInfo();
                renderingInfo.applyResourceBundle(resourceBundle);
            }
        }

        @Override
        public boolean contains(String parameterName) throws NullPointerException {
            return this.getParameter(parameterName) != null;
        }

        @Override
        public boolean contains(Parameter parameter) throws NullPointerException {
            return this.getParameter(parameter.getDefinition().getName()) != null;
        }

        @Override
        public boolean add(Parameter parameter) throws NullPointerException, IllegalArgumentException {
            if (parameter.getDefinition().isHidden() != this.m_onlyHidden) {
                throw new IllegalArgumentException(LOG.getMsgString("ParametersImpl.hidden", new Object[]{parameter.getName(), parameter.getDefinition().isHidden()}));
            }
            return ParametersImpl.this.add(parameter);
        }

        @Override
        public boolean remove(String parameterName) throws NullPointerException {
            if (this.contains(parameterName)) {
                return ParametersImpl.this.remove(parameterName);
            }
            return false;
        }

        @Override
        public boolean remove(Parameter parameter) throws NullPointerException {
            if (this.contains(parameter)) {
                return ParametersImpl.this.remove(parameter);
            }
            return false;
        }

        @Override
        public int size() {
            Parameter[] allParams = (Parameter[])ParametersImpl.this.toArray();
            int retSize = 0;
            for (int i = 0; i < allParams.length; ++i) {
                if (allParams[i].getDefinition().isHidden() != this.m_onlyHidden) continue;
                ++retSize;
            }
            return retSize;
        }

        @Override
        public void clear() {
            Parameter[] allParams = (Parameter[])ParametersImpl.this.toArray();
            for (int i = 0; i < allParams.length; ++i) {
                if (allParams[i].getDefinition().isHidden() != this.m_onlyHidden) continue;
                ParametersImpl.this.remove(allParams[i]);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            Parameter[] allArray = (Parameter[])ParametersImpl.this.toArray();
            Object[] retArray = new Parameter[this.size()];
            if (retArray.length > 0) {
                int retIndex = 0;
                for (int i = 0; i < allArray.length; ++i) {
                    if (allArray[i].getDefinition().isHidden() != this.m_onlyHidden) continue;
                    retArray[retIndex++] = allArray[i];
                }
            }
            return retArray;
        }

        @Override
        public boolean contains(Object o) throws ClassCastException, NullPointerException {
            if (o == null) {
                throw new NullPointerException("o=null");
            }
            if (o instanceof String) {
                return this.contains((String)o);
            }
            if (o instanceof Parameter) {
                return this.contains((Parameter)o);
            }
            throw new ClassCastException(LOG.getMsgString("ParametersImpl.must-be-string-or-param", new Object[0]));
        }

        @Override
        public boolean remove(Object o) throws ClassCastException, NullPointerException {
            if (o == null) {
                throw new NullPointerException("o=null");
            }
            if (o instanceof String) {
                return this.remove((String)o);
            }
            if (o instanceof Parameter) {
                return this.remove((Parameter)o);
            }
            throw new ClassCastException(LOG.getMsgString("ParametersImpl.must-be-string-or-param", new Object[0]));
        }

        @Override
        public boolean addAll(Collection<? extends Parameter> c) throws ClassCastException, NullPointerException, IllegalArgumentException {
            if (c == null) {
                throw new NullPointerException("c=null");
            }
            boolean changed = false;
            if (!c.isEmpty()) {
                for (Parameter parameter : c) {
                    changed |= this.add(parameter);
                }
            }
            return changed;
        }

        @Override
        public boolean containsAll(Collection c) throws ClassCastException, NullPointerException {
            boolean hasAll;
            if (c == null) {
                throw new NullPointerException("c=null");
            }
            if (!c.isEmpty()) {
                Object element;
                Iterator iter = c.iterator();
                for (hasAll = true; iter.hasNext() && hasAll; hasAll &= this.contains(element)) {
                    element = iter.next();
                }
            }
            return hasAll;
        }

        @Override
        public boolean removeAll(Collection c) {
            if (c == null) {
                throw new NullPointerException("c=null");
            }
            boolean changed = false;
            if (!c.isEmpty()) {
                for (Object element : c) {
                    changed |= this.remove(element);
                }
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.clear();
            for (Object object : c) {
                this.add((Parameter)object);
            }
            return true;
        }

        @Override
        public Iterator<Parameter> iterator() {
            TreeMap<ParameterNameIndex, Parameter> map = new TreeMap<ParameterNameIndex, Parameter>(new SortedParameterNameIndexComparator());
            Set entrySet = ParametersImpl.this.m_parameters.entrySet();
            for (Map.Entry entry : entrySet) {
                Parameter param = (Parameter)entry.getValue();
                if (param.getDefinition().isHidden() != this.m_onlyHidden) continue;
                map.put((ParameterNameIndex)entry.getKey(), param);
            }
            return map.values().iterator();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] retArray;
            Object[] proxyParameters = this.toArray();
            if (a.length >= proxyParameters.length) {
                System.arraycopy(proxyParameters, 0, a, 0, proxyParameters.length);
                if (a.length > proxyParameters.length) {
                    a[proxyParameters.length] = null;
                }
                retArray = a;
            } else {
                retArray = proxyParameters;
            }
            return retArray;
        }
    }
}

