/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import org.rhq.core.gui.util.FacesComponentIdFactory;
import org.rhq.core.gui.util.FacesComponentUtility;

public class RawConfigUIComponent
extends UIComponentBase {
    private static final String family = "rhq";
    private static final CharSequence TABLE_STYLE = "<style type=\"text/css\">td.raw-config-table {vertical-align: top;valign: top;}</style>";
    private FacesComponentIdFactory idFactory;
    private HtmlInputTextarea inputTextarea;
    private ArrayList<String> configPathList;
    public HtmlCommandLink saveLink;
    private Vector<HtmlCommandLink> pathCommandLinks;
    private ArrayList<UIParameter> readOnlyParms;
    private boolean readOnly;

    public String getFamily() {
        return family;
    }

    private void buildChildren() {
        if (this.getChildCount() > 0) {
            return;
        }
        FacesComponentUtility.addVerbatimText((UIComponent)this, TABLE_STYLE);
        HtmlPanelGroup rawPanel = FacesComponentUtility.addBlockPanel((UIComponent)this, this.idFactory, "");
        HtmlPanelGrid grid = FacesComponentUtility.addPanelGrid((UIComponent)rawPanel, this.idFactory, 2, "summary-props-table");
        grid.setParent((UIComponent)this);
        grid.setColumnClasses("raw-config-table");
        HtmlPanelGrid panelLeft = FacesComponentUtility.addPanelGrid((UIComponent)grid, this.idFactory, 1, "summary-props-table");
        panelLeft.setBgcolor("#a4b2b9");
        FacesComponentUtility.addOutputText((UIComponent)panelLeft, this.idFactory, "Raw Configurations Paths", "");
        int rawCount = 0;
        this.configPathList = new ArrayList();
        Collections.sort(this.configPathList);
        String oldDirname = "";
        this.pathCommandLinks = new Vector();
        for (String s : this.configPathList) {
            String dirname = s.substring(0, s.lastIndexOf("/") + 1);
            String basename = s.substring(s.lastIndexOf("/") + 1, s.length());
            if (!dirname.equals(oldDirname)) {
                FacesComponentUtility.addOutputText((UIComponent)panelLeft, this.idFactory, dirname, "");
                oldDirname = dirname;
            }
            HtmlPanelGroup nextPath = FacesComponentUtility.addBlockPanel((UIComponent)panelLeft, this.idFactory, "");
            HtmlCommandLink link = FacesComponentUtility.addCommandLink((UIComponent)nextPath, this.idFactory);
            FacesComponentUtility.addOutputText((UIComponent)link, this.idFactory, "", "");
            FacesComponentUtility.addOutputText((UIComponent)link, this.idFactory, basename, "");
            FacesComponentUtility.addParameter((UIComponent)link, this.idFactory, "path", s);
            FacesComponentUtility.addParameter((UIComponent)link, this.idFactory, "whichRaw", Integer.toString(rawCount++));
            FacesComponentUtility.addParameter((UIComponent)link, this.idFactory, "showRaw", Boolean.TRUE.toString());
            this.readOnlyParms.add(FacesComponentUtility.addParameter((UIComponent)link, this.idFactory, "readOnly", Boolean.toString(this.readOnly)));
            this.pathCommandLinks.add(link);
        }
        HtmlPanelGroup panelRight = FacesComponentUtility.addBlockPanel((UIComponent)grid, this.idFactory, "summary-props-table");
        HtmlPanelGroup editPanel = FacesComponentUtility.addBlockPanel((UIComponent)panelRight, this.idFactory, "summary-props-table");
        this.inputTextarea = this.createConfigTextArea(this.readOnly);
        editPanel.getChildren().add(this.inputTextarea);
        this.inputTextarea.setParent((UIComponent)editPanel);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.buildChildren();
    }

    public ArrayList<String> getConfigPathList() {
        return this.configPathList;
    }

    public void setConfigPathList(ArrayList<String> configPathList) {
        this.configPathList = configPathList;
    }

    private HtmlInputTextarea createConfigTextArea(boolean readOnly) {
        HtmlInputTextarea inputTextarea = new HtmlInputTextarea();
        inputTextarea.setId("rawconfigtextarea");
        inputTextarea.setCols(80);
        inputTextarea.setRows(40);
        inputTextarea.setReadonly(readOnly);
        return inputTextarea;
    }
}

