/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hudson;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.hudson.HudsonJSONUtility;

public class HudsonServerComponent
implements ResourceComponent {
    private ResourceContext resourceContext;
    private Map<String, JSONArray> healthMap = new HashMap<String, JSONArray>();

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            JSONObject server = HudsonJSONUtility.getData(this.resourceContext.getPluginConfiguration().getSimple("urlBase").getStringValue(), 1);
            JSONArray jobs = server.getJSONArray("jobs");
            for (int i = 0; i < jobs.length(); ++i) {
                JSONObject job = jobs.getJSONObject(i);
                JSONArray healthArray = job.getJSONArray("healthReport");
                String url = job.getString("url");
                this.healthMap.put(url, healthArray);
            }
            return AvailabilityType.UP;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    public JSONArray getProjectHealth(String url) {
        return this.healthMap.get(url);
    }

    public String getPath() {
        return this.resourceContext.getPluginConfiguration().getSimple("urlBase").getStringValue();
    }
}

