/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.login.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.bundle.BundleAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.content.ContentAgentService;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.clientapi.agent.operation.OperationAgentService;
import org.rhq.core.clientapi.agent.support.SupportAgentService;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.PluginContainerMBeanImpl;
import org.rhq.core.pc.RebootRequestListener;
import org.rhq.core.pc.agent.AgentRegistrar;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.agent.AgentServiceLifecycleListener;
import org.rhq.core.pc.agent.AgentServiceStreamRemoter;
import org.rhq.core.pc.bundle.BundleManager;
import org.rhq.core.pc.configuration.ConfigurationManager;
import org.rhq.core.pc.configuration.ConfigurationManagerInitializer;
import org.rhq.core.pc.content.ContentManager;
import org.rhq.core.pc.event.EventManager;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.inventory.ResourceFactoryManager;
import org.rhq.core.pc.measurement.MeasurementManager;
import org.rhq.core.pc.operation.OperationManager;
import org.rhq.core.pc.plugin.PluginComponentFactory;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pc.support.SupportManager;
import org.rhq.core.pluginapi.util.FileUtils;

public class PluginContainer
implements ContainerService {
    private static final PluginContainer INSTANCE = new PluginContainer();
    private final Log log = LogFactory.getLog(PluginContainer.class);
    private PluginContainerMBeanImpl mbean;
    private PluginContainerConfiguration configuration;
    private String version;
    private boolean started = false;
    private PluginManager pluginManager;
    private PluginComponentFactory pluginComponentFactory;
    private InventoryManager inventoryManager;
    private MeasurementManager measurementManager;
    private ConfigurationManager configurationManager;
    private OperationManager operationManager;
    private ResourceFactoryManager resourceFactoryManager;
    private ContentManager contentManager;
    private EventManager eventManager;
    private SupportManager supportManager;
    private BundleManager bundleManager;
    private Collection<AgentServiceLifecycleListener> agentServiceListeners = new LinkedHashSet<AgentServiceLifecycleListener>();
    private AgentServiceStreamRemoter agentServiceStreamRemoter = null;
    private AgentRegistrar agentRegistrar = null;
    private RebootRequestListener rebootListener = new NullRebootRequestListener();
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private List<InitializationListener> initListeners;
    private Object initListenersLock = new Object();

    public static PluginContainer getInstance() {
        return INSTANCE;
    }

    private PluginContainer() {
        try {
            Configuration.getConfiguration();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void addAgentServiceLifecycleListener(AgentServiceLifecycleListener listener) {
        this.agentServiceListeners.add(listener);
    }

    public void removeAgentServiceLifecycleListener(AgentServiceLifecycleListener listener) {
        this.agentServiceListeners.remove(listener);
    }

    public AgentServiceStreamRemoter getAgentServiceStreamRemoter() {
        return this.agentServiceStreamRemoter;
    }

    public void setAgentServiceStreamRemoter(AgentServiceStreamRemoter streamRemoter) {
        this.agentServiceStreamRemoter = streamRemoter;
    }

    public AgentRegistrar getAgentRegistrar() {
        return this.agentRegistrar;
    }

    public void setAgentRegistrar(AgentRegistrar registrar) {
        this.agentRegistrar = registrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Lock lock = this.obtainReadLock();
        try {
            boolean bl = this.started;
            return bl;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        this.initListeners = new LinkedList<InitializationListener>();
        Lock lock = this.obtainWriteLock();
        try {
            if (!this.started) {
                this.version = PluginContainer.class.getPackage().getImplementationVersion();
                this.log.info((Object)("Initializing Plugin Container" + (this.version != null ? " v" + this.version : "") + "..."));
                if (this.configuration == null) {
                    this.configuration = new PluginContainerConfiguration();
                }
                this.purgeTmpDirectoryContents();
                this.mbean = new PluginContainerMBeanImpl(this);
                this.mbean.register();
                ResourceContainer.initialize();
                this.pluginManager = new PluginManager();
                this.pluginComponentFactory = new PluginComponentFactory();
                this.inventoryManager = new InventoryManager();
                this.measurementManager = new MeasurementManager();
                this.configurationManager = new ConfigurationManager();
                this.operationManager = new OperationManager();
                this.resourceFactoryManager = new ResourceFactoryManager();
                this.contentManager = new ContentManager();
                this.eventManager = new EventManager();
                this.supportManager = new SupportManager();
                this.bundleManager = new BundleManager();
                this.startContainerService(this.pluginManager);
                this.startContainerService(this.pluginComponentFactory);
                this.startContainerService(this.inventoryManager);
                this.startContainerService(this.measurementManager);
                this.startContainerService(this.configurationManager);
                this.startContainerService(this.operationManager);
                this.startContainerService(this.resourceFactoryManager);
                this.startContainerService(this.contentManager);
                this.startContainerService(this.eventManager);
                this.startContainerService(this.supportManager);
                this.startContainerService(this.bundleManager);
                this.started = true;
                this.log.info((Object)"Plugin Container initialized.");
            }
        }
        finally {
            this.releaseLock(lock);
        }
        Object object = this.initListenersLock;
        synchronized (object) {
            if (this.started) {
                for (InitializationListener listener : this.initListeners) {
                    listener.initialized();
                }
            }
            this.initListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Lock lock = this.obtainWriteLock();
        try {
            if (this.started) {
                this.log.info((Object)"Plugin container is being shutdown...");
                if (this.mbean != null) {
                    this.mbean.unregister();
                    this.mbean = null;
                }
                boolean isInsideAgent = this.configuration.isInsideAgent();
                this.bundleManager.shutdown();
                this.supportManager.shutdown();
                this.eventManager.shutdown();
                this.contentManager.shutdown();
                this.resourceFactoryManager.shutdown();
                this.operationManager.shutdown();
                this.configurationManager.shutdown();
                this.measurementManager.shutdown();
                this.inventoryManager.shutdown();
                this.pluginComponentFactory.shutdown();
                this.pluginManager.shutdown();
                this.agentServiceListeners.clear();
                this.agentServiceListeners = new LinkedHashSet<AgentServiceLifecycleListener>();
                this.agentServiceStreamRemoter = null;
                this.agentRegistrar = null;
                this.purgeTmpDirectoryContents();
                ResourceContainer.shutdown();
                this.bundleManager = null;
                this.supportManager = null;
                this.eventManager = null;
                this.contentManager = null;
                this.resourceFactoryManager = null;
                this.operationManager = null;
                this.configurationManager = null;
                this.measurementManager = null;
                this.inventoryManager = null;
                this.pluginComponentFactory = null;
                this.pluginManager = null;
                this.configuration = null;
                this.started = false;
                this.log.info((Object)"Plugin container is now shutdown.");
                if (isInsideAgent) {
                    this.cleanMemory();
                }
            }
        }
        finally {
            this.releaseLock(lock);
        }
    }

    private void cleanMemory() {
        Introspector.flushCaches();
        LogFactory.releaseAll();
        try {
            Configuration.setConfiguration(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void purgeTmpDirectoryContents() {
        try {
            FileUtils.purge((File)this.configuration.getTemporaryDirectory(), (boolean)false);
        }
        catch (IOException e) {
            this.log.warn((Object)("Failed to purge contents of temporary directory - cause: " + e));
        }
    }

    private void startContainerService(ContainerService containerService) {
        this.log.debug((Object)("Starting and configuring container service: " + containerService.getClass().getSimpleName()));
        containerService.setConfiguration(this.configuration);
        AgentService agentService = null;
        if (containerService instanceof AgentService) {
            agentService = (AgentService)((Object)containerService);
            agentService.setAgentServiceStreamRemoter(this.agentServiceStreamRemoter);
            for (AgentServiceLifecycleListener agentServiceListener : this.agentServiceListeners) {
                agentService.addLifecycleListener(agentServiceListener);
            }
            if (containerService instanceof ConfigurationManager) {
                ConfigurationManagerInitializer initializer = new ConfigurationManagerInitializer();
                initializer.initialize((ConfigurationManager)containerService);
            }
        }
        containerService.initialize();
        if (agentService != null) {
            agentService.notifyLifecycleListenersOfNewState(AgentService.LifecycleState.STARTED);
        }
    }

    private Lock obtainReadLock() {
        Lock readLock = this.rwLock.readLock();
        try {
            if (!readLock.tryLock(60L, TimeUnit.SECONDS)) {
                String msg = "There may be a deadlock in the plugin container.";
                this.log.warn((Object)msg, new Throwable(msg));
                readLock = null;
            }
        }
        catch (InterruptedException e) {
            readLock = null;
        }
        return readLock;
    }

    private Lock obtainWriteLock() {
        Lock writeLock = this.rwLock.writeLock();
        try {
            if (!writeLock.tryLock(60L, TimeUnit.SECONDS)) {
                String msg = "There may be a deadlock in the plugin container.";
                this.log.warn((Object)msg, new Throwable(msg));
                writeLock = null;
            }
        }
        catch (InterruptedException e) {
            writeLock = null;
        }
        return writeLock;
    }

    private void releaseLock(Lock lock) {
        if (lock != null) {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginManager getPluginManager() {
        Lock lock = this.obtainReadLock();
        try {
            PluginManager pluginManager = this.pluginManager;
            return pluginManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginComponentFactory getPluginComponentFactory() {
        Lock lock = this.obtainReadLock();
        try {
            PluginComponentFactory pluginComponentFactory = this.pluginComponentFactory;
            return pluginComponentFactory;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryManager getInventoryManager() {
        Lock lock = this.obtainReadLock();
        try {
            InventoryManager inventoryManager = this.inventoryManager;
            return inventoryManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationManager getConfigurationManager() {
        Lock lock = this.obtainReadLock();
        try {
            ConfigurationManager configurationManager = this.configurationManager;
            return configurationManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasurementManager getMeasurementManager() {
        Lock lock = this.obtainReadLock();
        try {
            MeasurementManager measurementManager = this.measurementManager;
            return measurementManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationManager getOperationManager() {
        Lock lock = this.obtainReadLock();
        try {
            OperationManager operationManager = this.operationManager;
            return operationManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceFactoryManager getResourceFactoryManager() {
        Lock lock = this.obtainReadLock();
        try {
            ResourceFactoryManager resourceFactoryManager = this.resourceFactoryManager;
            return resourceFactoryManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentManager getContentManager() {
        Lock lock = this.obtainReadLock();
        try {
            ContentManager contentManager = this.contentManager;
            return contentManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventManager getEventManager() {
        Lock lock = this.obtainReadLock();
        try {
            EventManager eventManager = this.eventManager;
            return eventManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SupportManager getSupportManager() {
        Lock lock = this.obtainReadLock();
        try {
            SupportManager supportManager = this.supportManager;
            return supportManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleManager getBundleManager() {
        Lock lock = this.obtainReadLock();
        try {
            BundleManager bundleManager = this.bundleManager;
            return bundleManager;
        }
        finally {
            this.releaseLock(lock);
        }
    }

    public DiscoveryAgentService getDiscoveryAgentService() {
        return this.getInventoryManager();
    }

    public ConfigurationAgentService getConfigurationAgentService() {
        return this.getConfigurationManager();
    }

    public MeasurementAgentService getMeasurementAgentService() {
        return this.getMeasurementManager();
    }

    public OperationAgentService getOperationAgentService() {
        return this.getOperationManager();
    }

    public ResourceFactoryAgentService getResourceFactoryAgentService() {
        return this.getResourceFactoryManager();
    }

    public ContentAgentService getContentAgentService() {
        return this.getContentManager();
    }

    public SupportAgentService getSupportAgentService() {
        return this.getSupportManager();
    }

    public BundleAgentService getBundleAgentService() {
        return this.getBundleManager();
    }

    public boolean isInsideAgent() {
        return this.configuration != null && this.configuration.isInsideAgent();
    }

    public void setRebootRequestListener(RebootRequestListener listener) {
        this.rebootListener = listener;
    }

    public void notifyRebootRequestListener() {
        this.rebootListener.reboot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitializationListener(InitializationListener listener) {
        Object object = this.initListenersLock;
        synchronized (object) {
            if (this.started) {
                listener.initialized();
            } else {
                this.initListeners.add(listener);
            }
        }
    }

    public static interface InitializationListener {
        public void initialized();
    }

    private static final class NullRebootRequestListener
    implements RebootRequestListener {
        private NullRebootRequestListener() {
        }

        @Override
        public void reboot() {
        }
    }
}

